/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.nameRemover;

import com.dreammaster.gthandler.gui.CoreMod_UITextures;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.common.items.GT_IntegratedCircuit_Item;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class NameRemover
extends GT_MetaTileEntity_BasicMachine {
    private static final FallbackableUITexture progressBarTexture = GT_UITextures.fallbackableProgressbar((String)"name_remover", (UITexture)CoreMod_UITextures.PROGRESSBAR_NAME_REMOVER);

    public NameRemover(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Can fix GT items with broken NBT data, will erase everything!", 2, 1, new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER)});
    }

    public NameRemover(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NameRemover(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public int checkRecipe() {
        if (this.getInputAt(0) == null) {
            return 0;
        }
        ItemStack output = this.getInputAt(0).func_77946_l();
        NBTTagCompound nbt = output.func_77978_p();
        boolean removeName = false;
        boolean removeDye = false;
        boolean removeDisassembly = false;
        boolean removeColor = false;
        boolean removeRepair = false;
        boolean removeSpray = false;
        if (nbt != null) {
            ItemStack circuit = this.getInputAt(1);
            int circuitSetting = 0;
            if (circuit != null && circuit.func_77973_b() instanceof GT_IntegratedCircuit_Item) {
                circuitSetting = circuit.func_77960_j();
            }
            switch (circuitSetting) {
                case 1: {
                    removeName = true;
                    break;
                }
                case 2: {
                    removeDisassembly = true;
                    break;
                }
                case 3: {
                    removeColor = true;
                    break;
                }
                case 4: {
                    removeRepair = true;
                    break;
                }
                case 5: {
                    removeDye = true;
                    break;
                }
                case 6: {
                    removeSpray = true;
                    break;
                }
                default: {
                    removeName = true;
                    removeDisassembly = true;
                    removeColor = true;
                    removeRepair = true;
                    removeDye = true;
                    removeSpray = true;
                }
            }
            if (removeName && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("Name");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeDisassembly && nbt.func_74764_b("GT.CraftingComponents")) {
                nbt.func_82580_o("GT.CraftingComponents");
            }
            if (removeColor && nbt.func_74764_b("color")) {
                nbt.func_82580_o("color");
            }
            if (removeRepair && nbt.func_74764_b("RepairCost")) {
                nbt.func_82580_o("RepairCost");
            }
            if (removeDye && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("color");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeSpray && nbt.func_74764_b("mColor")) {
                nbt.func_82580_o("mColor");
            }
            if (nbt.func_82582_d()) {
                output.func_77982_d(null);
            }
        }
        if (this.canOutput(new ItemStack[]{output})) {
            this.getInputAt((int)0).field_77994_a = 0;
            this.mEUt = 0;
            this.mMaxProgresstime = 20;
            this.mOutputItems[0] = output;
            return 2;
        }
        return 0;
    }

    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Removes various NBT tags.");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "First Slot" + EnumChatFormatting.RESET);
        description.add("The item you want to strip of NBT");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Second Slot" + EnumChatFormatting.RESET);
        description.add("One of the following circuits:");
        description.add(EnumChatFormatting.BOLD + "Circuit 1:" + EnumChatFormatting.RESET + "  Attempt to fix broken ores by removing the Display Name tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 3:" + EnumChatFormatting.RESET + "  Remove Railcraft stacking tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 4:" + EnumChatFormatting.RESET + "  Remove Anvil repair tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 5:" + EnumChatFormatting.RESET + "  Remove Dye from Leather armor");
        description.add(EnumChatFormatting.BOLD + "Circuit 6:" + EnumChatFormatting.RESET + "  Remove Spray color from GT items");
        description.add(" ");
        description.add(EnumChatFormatting.BOLD + "No Circuit:" + EnumChatFormatting.RESET + " Remove all of the above");
        return description.toArray(new String[0]);
    }

    public boolean isElectric() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }

    public boolean useModularUI() {
        return true;
    }

    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).build();
    }
}

