/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.asm.DummyCompiler;
import java.nio.charset.StandardCharsets;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DeprecatedRedirectTransformer
implements RfbClassTransformer {
    final String COMPILER_NAME = "java/lang/Compiler";
    final byte[] COMPILER_NAME_BYTES = "java/lang/Compiler".getBytes(StandardCharsets.UTF_8);
    final String COMPILER_REDIRECTION_NAME = Type.getInternalName(DummyCompiler.class);

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "undeprecator";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        int classVersion = classNode.getOriginalMetadata() != null ? classNode.getOriginalMetadata().majorVersion : 8;
        return classVersion < 65 && ClassHeaderMetadata.hasSubstring(classNode.getOriginalBytes(), this.COMPILER_NAME_BYTES);
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null || node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode rawInsn : method.instructions) {
                if (rawInsn.getType() != 5) continue;
                MethodInsnNode insn = (MethodInsnNode)rawInsn;
                if (!insn.owner.equals("java/lang/Compiler")) continue;
                insn.owner = this.COMPILER_REDIRECTION_NAME;
            }
        }
    }
}

