/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import sun.misc.Unsafe;

public class UnsafeReflectionRedirector {
    private static final Class<?> fieldClass = Field.class;
    private static final Field fieldModifiers;
    private static final Set<Field> unlockedFields;
    private static final Unsafe unsafe;

    private static synchronized void unlockField(Field f) {
        unlockedFields.add(f);
    }

    private static synchronized boolean isFieldUnlocked(Field f) {
        return unlockedFields.contains(f);
    }

    public static Field getDeclaredField(Class<?> klass, String name) throws NoSuchFieldException, SecurityException {
        if (klass == fieldClass) {
            if ("modifiers".equals(name)) {
                return fieldModifiers;
            }
            throw new NoSuchFieldException(klass.getName() + "#" + name);
        }
        return klass.getDeclaredField(name);
    }

    public static Field[] getDeclaredFields(Class<?> klass) throws NoSuchFieldException, SecurityException {
        if (klass == fieldClass) {
            return new Field[]{fieldModifiers};
        }
        return klass.getDeclaredFields();
    }

    public static void setInt(Field field, Object target, int value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            Field targetF = (Field)target;
            int actualModifiers = targetF.getModifiers();
            if (Modifier.isStatic(actualModifiers) && Modifier.isFinal(actualModifiers)) {
                if ((value & 0x10) == 0) {
                    UnsafeReflectionRedirector.unlockField(targetF);
                }
            } else {
                targetF.setAccessible(true);
            }
            return;
        }
        field.setInt(target, value);
    }

    public static int getInt(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            Field targetF = (Field)target;
            boolean isUnlocked = UnsafeReflectionRedirector.isFieldUnlocked(targetF);
            int modifiers = targetF.getModifiers();
            if (isUnlocked) {
                modifiers &= 0xFFFFFFEF;
            }
            return modifiers;
        }
        return field.getInt(target);
    }

    public static void set(Field field, Object target, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (UnsafeReflectionRedirector.isFieldUnlocked(field)) {
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException("unsafe redirect of non-static field set");
            }
            if (!field.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Field " + field.getType() + " not assignable from " + value.getClass());
            }
            long staticOffset = unsafe.staticFieldOffset(field);
            Object staticObject = unsafe.staticFieldBase(field);
            unsafe.putObjectVolatile(staticObject, staticOffset, value);
        } else {
            field.set(target, value);
        }
    }

    static {
        unlockedFields = Collections.newSetFromMap(new WeakHashMap());
        try {
            fieldModifiers = Dummy.class.getDeclaredField("modifiers");
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Dummy {
        private int modifiers;
    }
}

