/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.asm;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class SafeAsmClassWriter
extends ClassWriter {
    public static final ThreadLocal<Integer> forcedFlags = ThreadLocal.withInitial(() -> 0);
    public static final ThreadLocal<byte[]> forcedOriginalClass = new ThreadLocal();

    public SafeAsmClassWriter(int flags) {
        super(flags | forcedFlags.get());
        if (forcedOriginalClass.get() != null) {
            ClassHeaderMetadata chm = new ClassHeaderMetadata(forcedOriginalClass.get());
            super.visit(chm.majorVersion, chm.accessFlags, chm.binaryThisName, null, chm.binarySuperName, null);
        }
    }

    public SafeAsmClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags | forcedFlags.get());
    }

    @Override
    protected ClassLoader getClassLoader() {
        ExtensibleClassLoader launchLoader = Main.launchLoader;
        return launchLoader != null ? launchLoader.asURLClassLoader() : Main.compatLoader;
    }
}

