/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.core;

import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.eigenraven.lwjgl3ify.core.Config;
import me.eigenraven.lwjgl3ify.core.LateInit;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFD)
public class Lwjgl3ifyCoremod
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"lwjgl3ify");

    public Lwjgl3ifyCoremod() {
        try {
            LaunchClassLoader launchLoader = (LaunchClassLoader)this.getClass().getClassLoader();
            launchLoader.addClassLoaderExclusion("org.hotswap.agent");
            launchLoader.addClassLoaderExclusion("org.lwjglx.debug");
        }
        catch (ClassCastException e) {
            LOGGER.warn("Unsupported launch class loader type " + this.getClass().getClassLoader().getClass(), (Throwable)e);
        }
        Config.loadConfig();
        if (Launch.blackboard.get("lwjgl3ify:rfb-booted") != Boolean.TRUE) {
            return;
        }
        LateInit.lateConstruct();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.lwjgl3ify.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        boolean hasFastcraft = loadedCoreMods.contains("fastcraft.Tweaker");
        boolean hasOptifine = loadedCoreMods.contains("optifine.OptiFineForgeTweaker");
        ArrayList<String> mixins = new ArrayList<String>(8);
        mixins.add("fml.ItemStackHolderRef");
        mixins.add("fml.JarDiscoverer");
        mixins.add("fml.ObjectHolderRef");
        mixins.add("fml.ObjectHolderRegistry");
        if (FMLLaunchHandler.side().isClient()) {
            boolean fcBugTriggered;
            mixins.add("game.MixinMinecraftKeyBinding");
            if (Config.MIXIN_STBI_TEXTURE_LOADING) {
                LOGGER.info("Enabling STB texture loading mixin");
                mixins.add("game.MixinTextureAtlasSprite");
                mixins.add("game.MixinTextureMap");
            } else {
                LOGGER.info("Disabling STB texture loading mixin");
            }
            boolean fcBugFixedByOF = Lwjgl3ifyCoremod.isFastcraftVersion1_25();
            boolean bl = fcBugTriggered = hasFastcraft && (!hasOptifine || !fcBugFixedByOF);
            if (fcBugTriggered && !Config.MIXIN_STBI_IGNORE_FASTCRAFT) {
                LOGGER.error("Not using STB stiching mixins because FastCraft is installed to prevent rapidly flashing screen. Remove FastCraft or " + (!fcBugFixedByOF ? "update to FastCraft 1.25 and " : "") + "add OptiFine to enable these performance-improving patches.");
            } else if (Config.MIXIN_STBI_TEXTURE_STICHING) {
                LOGGER.info("Enabling STB texture stitching mixin");
                mixins.add("game.MixinStitcher");
            } else {
                LOGGER.info("Disabling STB texture stitching mixin");
            }
        }
        return mixins;
    }

    private static boolean isFastcraftVersion1_25() {
        try {
            byte[] bytes = Launch.classLoader.getClassBytes("fastcraft.a");
            if (bytes == null) {
                return false;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(bytes);
            byte[] fc125AHash = new byte[]{-125, -16, 44, -79, -105, 108, -65, -19, 56, -98, -65, -94, 0, -49, 66, -58, -60, -39, -23, 55, 87, 127, -77, 100, 73, -92, 37, 84, 115, -114, -76, -23};
            return Arrays.equals(fc125AHash, hash);
        }
        catch (Exception e) {
            return false;
        }
    }
}

