/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.ScrollableTabPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

class DarkScrollableTabPanel
extends ScrollableTabPanel {
    protected final Rectangle iconRect = new Rectangle();
    protected final Rectangle textRect = new Rectangle();
    private final DarkTabbedPaneUI tabbedPaneUI;

    public DarkScrollableTabPanel(DarkTabbedPaneUI tabbedPaneUI) {
        super(tabbedPaneUI);
        this.tabbedPaneUI = tabbedPaneUI;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tabbedPaneUI.drawDropRect) {
            this.tabbedPaneUI.paintDrop(g);
        }
    }

    @Override
    public void doLayout() {
        if (this.getComponentCount() > 0) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component child = this.getComponent(i);
                if (child == this.tabbedPaneUI.scrollableTabSupport.newTabButton) {
                    int off;
                    boolean leftToRight = this.tabbedPaneUI.tabPane.getComponentOrientation().isLeftToRight();
                    int tabCount = this.tabbedPaneUI.tabPane.getTabCount();
                    Dimension b = child.getPreferredSize();
                    if (tabCount <= 0) continue;
                    if (this.tabbedPaneUI.isHorizontalTabPlacement()) {
                        int x;
                        int n = off = this.tabbedPaneUI.dropTargetIndex == tabCount ? this.tabbedPaneUI.dropRect.width : 0;
                        if (leftToRight) {
                            x = this.tabbedPaneUI.rects[tabCount - 1].x + this.tabbedPaneUI.rects[tabCount - 1].width + off;
                            child.setBounds(x, 0, b.width, this.tabbedPaneUI.maxTabHeight);
                            continue;
                        }
                        x = this.tabbedPaneUI.rects[tabCount - 1].x - off;
                        child.setBounds(x - b.width, 0, b.width, this.tabbedPaneUI.maxTabHeight);
                        continue;
                    }
                    off = this.tabbedPaneUI.dropTargetIndex == tabCount ? this.tabbedPaneUI.dropRect.height : 0;
                    int y = this.tabbedPaneUI.rects[tabCount - 1].y + this.tabbedPaneUI.rects[tabCount - 1].height + off;
                    child.setBounds(0, y, this.tabbedPaneUI.maxTabWidth, b.height);
                    continue;
                }
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.tabbedPaneUI.dragging && this.tabbedPaneUI.tabPane.getTabCount() > 0) {
            this.tabbedPaneUI.paintTab(g, this.tabbedPaneUI.tabPane.getTabPlacement(), this.tabbedPaneUI.dragRect, this.tabbedPaneUI.tabPane.getSelectedIndex(), this.iconRect, this.textRect);
            Component comp = this.tabbedPaneUI.tabPane.getTabComponentAt(this.tabbedPaneUI.dropSourceIndex);
            if (comp != null) {
                g.translate(comp.getX(), comp.getY());
                comp.print(g);
            }
        }
    }
}

