/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.steam;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_Steel;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_ForgeHammer_Steel
extends GT_MetaTileEntity_BasicMachine_Steel {
    public GT_MetaTileEntity_ForgeHammer_Steel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "Forge Hammer", 1, 1, true);
    }

    public GT_MetaTileEntity_ForgeHammer_Steel(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aDescription, aTextures, 1, 1, true);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ForgeHammer_Steel(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient(SoundResource.RANDOM_ANVIL_USE, 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    @Override
    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{super.getSideFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_HAMMER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_STEAM_HAMMER_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{super.getSideFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_HAMMER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_STEAM_HAMMER_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{super.getFrontFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{super.getFrontFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{super.getTopFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_HAMMER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_HAMMER_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{super.getTopFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_HAMMER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_HAMMER_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{super.getBottomFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_HAMMER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_HAMMER_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{super.getBottomFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_HAMMER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_HAMMER_GLOW).glow().build()};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isActive() && XSTR.XSTR_INSTANCE.nextInt(3) == 0) {
            ForgeDirection mainFacing = this.mMainFacing;
            if ((mainFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && aBaseMetaTileEntity.getCoverIDAtSide(mainFacing) == 0 && !aBaseMetaTileEntity.getOpacityAtSide(mainFacing)) {
                double mZ;
                double z;
                double mX;
                double x;
                double oX = aBaseMetaTileEntity.getXCoord();
                double oY = aBaseMetaTileEntity.getYCoord();
                double oZ = aBaseMetaTileEntity.getZCoord();
                double offset = 0.02;
                double horizontal = 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat() * 8.0 / 16.0 - 0.25;
                double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 + 0.3125;
                if (mainFacing == ForgeDirection.WEST) {
                    x = oX - 0.02;
                    mX = -0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.EAST) {
                    x = oX + 0.02;
                    mX = 0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.NORTH) {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ - 0.02;
                    mZ = -0.05;
                } else {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ + 0.02;
                    mZ = 0.05;
                }
                WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(mX, 0.0, mZ).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.LAVA)).run();
            }
        }
    }
}

