/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;

public class GT_MetaTileEntity_Charger
extends GT_MetaTileEntity_BasicBatteryBuffer {
    public GT_MetaTileEntity_Charger(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    public GT_MetaTileEntity_Charger(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public GT_MetaTileEntity_Charger(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Charger(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 64L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 256L * (long)this.mInventory.length;
    }

    @Override
    public long maxAmperesIn() {
        return Math.max((long)this.mChargeableCount * 8L, 4L);
    }

    @Override
    public long maxAmperesOut() {
        return Math.max((long)this.mBatteryCount * 4L, 2L);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            BaseMetaTileEntity mBaseMetaTileEntity;
            IMetaTileEntity iMetaTileEntity;
            super.onPostTick(aBaseMetaTileEntity, aTick);
            if (this.getBaseMetaTileEntity() instanceof BaseMetaTileEntity && (iMetaTileEntity = (mBaseMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity()).getMetaTileEntity()) instanceof MetaTileEntity) {
                int k;
                MetaTileEntity mMetaTileEntity = (MetaTileEntity)iMetaTileEntity;
                if (mMetaTileEntity.dechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() < mBaseMetaTileEntity.getEUCapacity()) {
                    int i;
                    k = mMetaTileEntity.dechargerSlotCount() + i;
                    for (i = mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                        if (mMetaTileEntity.mInventory[i] == null || mBaseMetaTileEntity.getStoredEU() >= mBaseMetaTileEntity.getEUCapacity()) continue;
                        mBaseMetaTileEntity.increaseStoredEnergyUnits(GT_ModHandler.dischargeElectricItem(mMetaTileEntity.mInventory[i], GT_Utility.safeInt(Math.min(GT_Values.V[this.mTier] * 15L, mBaseMetaTileEntity.getEUCapacity() - mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getInputTier()), true, false, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
                if (mMetaTileEntity.rechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() > 0L) {
                    int i;
                    k = mMetaTileEntity.rechargerSlotCount() + i;
                    for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                        if (mBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                        mBaseMetaTileEntity.decreaseStoredEU(GT_ModHandler.chargeElectricItem(mMetaTileEntity.mInventory[i], GT_Utility.safeInt(Math.min(GT_Values.V[this.mTier] * 15L, mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getOutputTier()), true, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
            }
        }
    }
}

