/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.common.misc.GlobalVariableStorage;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.WorldEvent;

public class GlobalEnergyWorldSavedData
extends WorldSavedData {
    public static GlobalEnergyWorldSavedData INSTANCE;
    private static final String DATA_NAME = "GregTech_WirelessEUWorldSavedData";
    private static final String GlobalEnergyNBTTag = "GregTech_GlobalEnergy_MapNBTTag";
    private static final String GlobalEnergyTeamNBTTag = "GregTech_GlobalEnergyTeam_MapNBTTag";

    private static void loadInstance(World world) {
        GlobalVariableStorage.GlobalEnergy.clear();
        MapStorage storage = world.field_72988_C;
        INSTANCE = (GlobalEnergyWorldSavedData)storage.func_75742_a(GlobalEnergyWorldSavedData.class, DATA_NAME);
        if (INSTANCE == null) {
            INSTANCE = new GlobalEnergyWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            GlobalEnergyWorldSavedData.loadInstance(event.world);
        }
    }

    public GlobalEnergyWorldSavedData() {
        super(DATA_NAME);
    }

    public GlobalEnergyWorldSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        Object data;
        ObjectInputStream objectInputStream;
        ByteArrayInputStream byteArrayInputStream;
        byte[] ba;
        try {
            ba = nbtTagCompound.func_74770_j(GlobalEnergyNBTTag);
            byteArrayInputStream = new ByteArrayInputStream(ba);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            data = objectInputStream.readObject();
            HashMap hashData = (HashMap)data;
            for (Map.Entry entry : hashData.entrySet()) {
                GlobalVariableStorage.GlobalEnergy.put(UUID.fromString(entry.getKey().toString()), (BigInteger)entry.getValue());
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            System.out.println("GregTech_GlobalEnergy_MapNBTTag FAILED");
            exception.printStackTrace();
        }
        try {
            if (!nbtTagCompound.func_74764_b(GlobalEnergyTeamNBTTag)) {
                return;
            }
            ba = nbtTagCompound.func_74770_j(GlobalEnergyTeamNBTTag);
            byteArrayInputStream = new ByteArrayInputStream(ba);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            data = objectInputStream.readObject();
            HashMap oldTeams = (HashMap)data;
            for (String member : oldTeams.keySet()) {
                String leader = (String)oldTeams.get(member);
                SpaceProjectManager.putInTeam(UUID.fromString(member), UUID.fromString(leader));
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            System.out.println("GregTech_GlobalEnergyTeam_MapNBTTag FAILED");
            exception.printStackTrace();
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(GlobalVariableStorage.GlobalEnergy);
            objectOutputStream.flush();
            byte[] data = byteArrayOutputStream.toByteArray();
            nbtTagCompound.func_74773_a(GlobalEnergyNBTTag, data);
        }
        catch (IOException exception) {
            System.out.println("GregTech_GlobalEnergy_MapNBTTag SAVE FAILED");
            exception.printStackTrace();
        }
    }
}

