/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_DoesWork
extends GT_CoverBehavior {
    private static int FLAG_INVERTED = 1;
    private static int FLAG_PROGRESS = 2;
    private static int FLAG_ENABLED = 4;

    public GT_Cover_DoesWork(ITexture coverTexture) {
        super(coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IMachineProgress) {
            int tScale;
            IMachineProgress mProgress = (IMachineProgress)((Object)aTileEntity);
            boolean inverted = GT_Cover_DoesWork.isFlagSet(aCoverVariable, FLAG_INVERTED);
            int signal = 0;
            signal = GT_Cover_DoesWork.isFlagSet(aCoverVariable, FLAG_ENABLED) ? (inverted == mProgress.isAllowedToWork() ? 0 : 15) : (GT_Cover_DoesWork.isFlagSet(aCoverVariable, FLAG_PROGRESS) ? (inverted == (mProgress.getMaxProgress() == 0) ? 0 : 15) : ((tScale = mProgress.getMaxProgress() / 15) > 0 && mProgress.hasThingsToDo() ? (inverted ? 15 - mProgress.getProgress() / tScale : mProgress.getProgress() / tScale) : (inverted ? 15 : 0)));
            aTileEntity.setOutputRedstoneSignal(side, (byte)signal);
        } else {
            aTileEntity.setOutputRedstoneSignal(side, (byte)0);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 6) < 0) {
            aCoverVariable = 5;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("018", "Normal"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("019", "Inverted"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("020", "Ready to work"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("021", "Not ready to work"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("028", "Machine Enabled"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("029", "Machine Disabled"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new DoesWorkUIFactory(buildContext).createWindow();
    }

    private static boolean isFlagSet(int coverVariable, int flag) {
        return (coverVariable & flag) == flag;
    }

    private class DoesWorkUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public DoesWorkUIFactory(GT_CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, GT_Cover_DoesWork.this, (id, coverData) -> this.isEnabled((int)id, GT_Cover_DoesWork.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, GT_Cover_DoesWork.convert(coverData)))).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_PROGRESS).setPos(0, 0)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_CHECKMARK).setPos(18, 0)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_POWER_SWITCH_ON).setPos(36, 0)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofRedstone(), widget -> widget.setPos(0, 18)).setPos(10, 25))).widget(TextWidget.dynamicString(() -> {
                int coverVariable = GT_Cover_DoesWork.convert((ISerializableObject.LegacyCoverData)this.getCoverData());
                if (GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_ENABLED)) {
                    return GT_Utility.trans("271", "Machine enabled");
                }
                if (GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_PROGRESS)) {
                    return GT_Utility.trans("242", "Machine idle");
                }
                return GT_Utility.trans("241", "Recipe progress");
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 29))).widget(TextWidget.dynamicString(() -> GT_Cover_DoesWork.isFlagSet(GT_Cover_DoesWork.convert((ISerializableObject.LegacyCoverData)this.getCoverData()), FLAG_INVERTED) ? GT_Utility.trans("INVERTED", "Inverted") : GT_Utility.trans("NORMAL", "Normal")).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 47));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    return coverVariable & ~FLAG_ENABLED & ~FLAG_PROGRESS;
                }
                case 1: {
                    return coverVariable & ~FLAG_ENABLED | FLAG_PROGRESS;
                }
                case 2: {
                    return coverVariable & ~FLAG_PROGRESS | FLAG_ENABLED;
                }
                case 3: {
                    if (GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_INVERTED)) {
                        return coverVariable & ~FLAG_INVERTED;
                    }
                    return coverVariable | FLAG_INVERTED;
                }
            }
            return coverVariable;
        }

        private boolean isEnabled(int id, int coverVariable) {
            boolean bl;
            switch (id) {
                case 0: {
                    if (!GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_PROGRESS) && !GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_ENABLED)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    bl = GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_PROGRESS);
                    break;
                }
                case 2: {
                    bl = GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_ENABLED);
                    break;
                }
                case 3: {
                    bl = GT_Cover_DoesWork.isFlagSet(coverVariable, FLAG_INVERTED);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

