/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.recipe;

import gregtech.api.util.GT_Recipe;
import gregtech.api.util.item.ItemHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeInputRequirements {
    protected Map<ItemHolder, Long> itemInputs = new HashMap<ItemHolder, Long>();
    protected Set<ItemHolder> itemInputsMet = new HashSet<ItemHolder>();
    protected boolean metAllItem = false;
    protected Map<Fluid, Long> fluidInputs = new HashMap<Fluid, Long>();
    protected Set<Fluid> fluidInputsMet = new HashSet<Fluid>();
    protected boolean metAllFluid = false;

    public RecipeInputRequirements(@Nonnull GT_Recipe recipe) {
        this(recipe.mInputs, recipe.mFluidInputs);
    }

    public RecipeInputRequirements(@Nonnull ItemStack[] itemInputs, @Nonnull FluidStack[] fluidInputs) {
        for (ItemStack itemStack : itemInputs) {
            if (itemStack == null) continue;
            ItemHolder itemIH = new ItemHolder(itemStack);
            this.itemInputs.put(itemIH, this.itemInputs.getOrDefault(itemIH, 0L) + (long)itemStack.field_77994_a);
        }
        for (ItemStack itemStack : fluidInputs) {
            if (itemStack == null) continue;
            this.fluidInputs.put(itemStack.getFluid(), this.fluidInputs.getOrDefault(itemStack.getFluid(), 0L) + (long)itemStack.amount);
        }
    }

    public boolean tryToFillItemRequirements(Map<ItemHolder, Long> itemInputs) {
        if (this.metAllItem) {
            return this.metAllItem;
        }
        for (Map.Entry<ItemHolder, Long> entry : itemInputs.entrySet()) {
            if (this.itemInputsMet.contains(entry.getKey()) || !this.itemInputs.containsKey(entry.getKey()) || this.itemInputs.get(entry.getKey()) > entry.getValue()) continue;
            this.itemInputsMet.add(entry.getKey());
        }
        this.metAllItem = this.itemInputsMet.containsAll(this.itemInputs.keySet());
        return this.metAllItem;
    }

    public boolean tryToFillFluidRequirements(Map<Fluid, Long> fluidInputs) {
        if (this.metAllFluid) {
            return this.metAllFluid;
        }
        for (Map.Entry<Fluid, Long> entry : fluidInputs.entrySet()) {
            if (this.fluidInputsMet.contains(entry.getKey()) || !this.fluidInputs.containsKey(entry.getKey()) || this.fluidInputs.get(entry.getKey()) > entry.getValue()) continue;
            this.fluidInputsMet.add(entry.getKey());
        }
        this.metAllFluid = this.fluidInputsMet.containsAll(this.fluidInputs.keySet());
        return this.metAllFluid;
    }
}

