/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_OreDictUnificator {
    private static final Map<String, ItemStack> sName2StackMap = new HashMap<String, ItemStack>();
    private static final Map<ItemStack, ItemData> sItemStack2DataMap = new Object2ObjectOpenCustomHashMap(GT_ItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static final Map<ItemStack, List<ItemStack>> sUnificationTable = new Object2ObjectOpenCustomHashMap(GT_ItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static final Set<ItemStack> sNoUnificationList = new ObjectOpenCustomHashSet(GT_ItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static int isRegisteringOre = 0;
    private static int isAddingOre = 0;
    private static boolean mRunThroughTheList = true;

    public static void addToBlacklist(ItemStack aStack) {
        if (GT_Utility.isStackValid(aStack) && !GT_Utility.isStackInStackSet(aStack, sNoUnificationList)) {
            sNoUnificationList.add(aStack);
        }
    }

    public static boolean isBlacklisted(ItemStack aStack) {
        return GT_Utility.isStackInStackSet(aStack, sNoUnificationList);
    }

    public static void add(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GT_OreDictUnificator.set(aPrefix, aMaterial, aStack, false, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GT_OreDictUnificator.set(aPrefix, aMaterial, aStack, true, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        if (aMaterial == null || aPrefix == null || GT_Utility.isStackInvalid(aStack) || Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            return;
        }
        ++isAddingOre;
        aStack = GT_Utility.copyAmount(1, aStack);
        if (!aAlreadyRegistered) {
            GT_OreDictUnificator.registerOre(aPrefix.get(aMaterial), aStack);
        }
        GT_OreDictUnificator.addAssociation(aPrefix, aMaterial, aStack, GT_OreDictUnificator.isBlacklisted(aStack));
        if (aOverwrite || GT_Utility.isStackInvalid(sName2StackMap.get(aPrefix.get(aMaterial).toString()))) {
            sName2StackMap.put(aPrefix.get(aMaterial).toString(), aStack);
        }
        --isAddingOre;
    }

    public static ItemStack getFirstOre(Object aName, long aAmount) {
        if (GT_Utility.isStringInvalid(aName)) {
            return null;
        }
        ItemStack tStack = sName2StackMap.get(aName.toString());
        if (GT_Utility.isStackValid(tStack)) {
            return GT_Utility.copyAmount(aAmount, tStack);
        }
        return GT_Utility.copyAmount(aAmount, GT_OreDictUnificator.getOresImmutable(aName).toArray());
    }

    public static ItemStack get(Object aName, long aAmount) {
        return GT_OreDictUnificator.get(aName, null, aAmount, true, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount) {
        return GT_OreDictUnificator.get(aName, aReplacement, aAmount, true, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, long aAmount) {
        return GT_OreDictUnificator.get(aPrefix, aMaterial, null, aAmount);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, ItemStack aReplacement, long aAmount) {
        if (OrePrefixes.mPreventableComponents.contains((Object)aPrefix) && aPrefix.mDisabledItems.contains(aMaterial)) {
            return aReplacement;
        }
        return GT_OreDictUnificator.get(aPrefix.get(aMaterial), aReplacement, aAmount, false, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, long aAmount, boolean aNoInvalidAmounts) {
        if (OrePrefixes.mPreventableComponents.contains((Object)aPrefix) && aPrefix.mDisabledItems.contains(aMaterial)) {
            return null;
        }
        return GT_OreDictUnificator.get(aPrefix.get(aMaterial), null, aAmount, false, aNoInvalidAmounts);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        ItemStack stackFirstOre;
        if (aNoInvalidAmounts && aAmount < 1L) {
            return null;
        }
        ItemStack stackFromName = sName2StackMap.get(aName.toString());
        if (stackFromName != null) {
            return GT_Utility.copyAmount(aAmount, stackFromName);
        }
        if (aMentionPossibleTypos) {
            GT_Log.err.println("Unknown Key for Unification, Typo? " + aName);
        }
        if ((stackFirstOre = GT_OreDictUnificator.getFirstOre(aName, aAmount)) != null) {
            return GT_Utility.copyAmount(aAmount, stackFirstOre);
        }
        return GT_Utility.copyAmount(aAmount, aReplacement);
    }

    public static ItemStack[] setStackArray(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = GT_OreDictUnificator.get(aUseBlackList, GT_Utility.copyOrNull(aStacks[i]));
        }
        return aStacks;
    }

    public static ItemStack[] getStackArray(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GT_OreDictUnificator.get(aUseBlackList, GT_Utility.copy(aStacks[i]), true);
        }
        return rStacks;
    }

    public static ItemStack setStack(ItemStack aStack) {
        return GT_OreDictUnificator.setStack(true, aStack);
    }

    public static ItemStack setStack(boolean aUseBlackList, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return aStack;
        }
        ItemStack tStack = GT_OreDictUnificator.get(aUseBlackList, aStack);
        if (GT_Utility.areStacksEqual(aStack, tStack)) {
            return aStack;
        }
        aStack.func_150996_a(tStack.func_77973_b());
        Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(tStack));
        return aStack;
    }

    public static ItemStack get(ItemStack aStack) {
        return GT_OreDictUnificator.get(true, aStack);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack) {
        return GT_OreDictUnificator.get(aUseBlackList, aStack, false);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack, boolean unsafe) {
        ItemStack rStack;
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aStack);
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData() || aUseBlackList && tPrefixMaterial.mBlackListed) {
            return GT_Utility.copyOrNull(aStack);
        }
        if (aUseBlackList && !GregTech_API.sUnificationEntriesRegistered && GT_OreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            return GT_Utility.copyOrNull(aStack);
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
        }
        if (GT_Utility.isStackInvalid(rStack = tPrefixMaterial.mUnificationTarget)) {
            return GT_Utility.copyOrNull(aStack);
        }
        ItemStack newStack = unsafe ? GT_Utility.copyAmountUnsafe(aStack.field_77994_a, rStack) : GT_Utility.copyAmount(aStack.field_77994_a, rStack);
        newStack.func_77982_d(aStack.func_77978_p());
        return newStack;
    }

    public static ItemStack get_nocopy(ItemStack aStack) {
        return GT_OreDictUnificator.get_nocopy(true, aStack);
    }

    static ItemStack get_nocopy(boolean aUseBlackList, ItemStack aStack) {
        ItemStack rStack;
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aStack);
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData() || aUseBlackList && tPrefixMaterial.mBlackListed) {
            return aStack;
        }
        if (aUseBlackList && !GregTech_API.sUnificationEntriesRegistered && GT_OreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            return aStack;
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
        }
        if (GT_Utility.isStackInvalid(rStack = tPrefixMaterial.mUnificationTarget)) {
            return aStack;
        }
        if (aStack.func_77978_p() == rStack.func_77978_p()) {
            return rStack;
        }
        ItemStack newStack = new ItemStack(rStack.func_77973_b(), aStack.field_77994_a, Items.field_151008_G.getDamage(rStack));
        newStack.func_77982_d(aStack.func_77978_p());
        return newStack;
    }

    public static boolean isInputStackEqual(ItemStack aStack, ItemStack unified_tStack) {
        boolean alreadyCompared = false;
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aStack);
        ItemStack rStack = null;
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData()) {
            return GT_Utility.areStacksEqual(aStack, unified_tStack, true);
        }
        if (tPrefixMaterial.mBlackListed) {
            if (GT_Utility.areStacksEqual(aStack, unified_tStack, true)) {
                return true;
            }
            alreadyCompared = true;
        }
        if (!alreadyCompared && !GregTech_API.sUnificationEntriesRegistered && GT_OreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            if (GT_Utility.areStacksEqual(aStack, unified_tStack, true)) {
                return true;
            }
            alreadyCompared = true;
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
        }
        if (GT_Utility.isStackInvalid(rStack = tPrefixMaterial.mUnificationTarget)) {
            return !alreadyCompared && GT_Utility.areStacksEqual(aStack, unified_tStack, true);
        }
        return GT_Utility.areStacksEqual(rStack, unified_tStack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemStack> getNonUnifiedStacks(Object obj) {
        if (sUnificationTable.isEmpty() && !sItemStack2DataMap.isEmpty()) {
            Map<ItemStack, List<ItemStack>> map = sUnificationTable;
            synchronized (map) {
                if (sUnificationTable.isEmpty() && !sItemStack2DataMap.isEmpty()) {
                    for (ItemStack tGTStack0 : sItemStack2DataMap.keySet()) {
                        ItemStack tStack1;
                        ItemStack tStack0 = GT_ItemStack.internalCopyStack(tGTStack0);
                        if (GT_Utility.areStacksEqual(tStack0, tStack1 = GT_OreDictUnificator.get_nocopy(false, tStack0))) continue;
                        List list = sUnificationTable.computeIfAbsent(tStack1, k -> new ArrayList());
                        list.add(tStack0);
                    }
                }
            }
        }
        ItemStack[] aStacks = new ItemStack[]{};
        if (obj instanceof ItemStack) {
            aStacks = new ItemStack[]{(ItemStack)obj};
        } else if (obj instanceof ItemStack[]) {
            aStacks = (ItemStack[])obj;
        } else if (obj instanceof List) {
            aStacks = ((List)obj).toArray(new ItemStack[0]);
        }
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (ItemStack aStack : aStacks) {
            if (aStack == null) continue;
            rList.add(aStack);
            List<ItemStack> tList = sUnificationTable.get(aStack);
            if (tList == null) continue;
            for (ItemStack tStack : tList) {
                ItemStack tStack1 = GT_Utility.copyAmount(aStack.field_77994_a, tStack);
                rList.add(tStack1);
            }
        }
        return rList;
    }

    public static void addItemData(ItemStack aStack, ItemData aData) {
        if (GT_Utility.isStackValid(aStack) && GT_OreDictUnificator.getItemData(aStack) == null && aData != null) {
            GT_OreDictUnificator.setItemData(aStack, aData);
        }
    }

    public static void addItemDataFromInputs(ItemStack output, Object ... inputs) {
        int length = inputs.length;
        ItemData[] tData = new ItemData[length];
        for (int i = 0; i < length; ++i) {
            if (inputs[i] instanceof ItemStack) {
                tData[i] = GT_OreDictUnificator.getItemData((ItemStack)inputs[i]);
                continue;
            }
            if (inputs[i] instanceof ItemData) {
                tData[i] = (ItemData)inputs[i];
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (GT_Utility.arrayContainsNonNull(tData)) {
            GT_OreDictUnificator.addItemData(output, new ItemData(tData));
        }
    }

    public static void setItemData(ItemStack aStack, ItemData aData) {
        block13: {
            ItemData tData;
            block11: {
                block12: {
                    if (GT_Utility.isStackInvalid(aStack) || aData == null) {
                        return;
                    }
                    tData = GT_OreDictUnificator.getItemData(aStack);
                    if (tData != null && tData.hasValidPrefixMaterialData()) break block11;
                    if (tData != null) {
                        for (Object tObject : tData.mExtraData) {
                            if (aData.mExtraData.contains(tObject)) continue;
                            aData.mExtraData.add(tObject);
                        }
                    }
                    if (aStack.field_77994_a > 1) {
                        if (aData.mMaterial != null) {
                            aData.mMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        aStack = GT_Utility.copyAmount(1, aStack);
                    }
                    sItemStack2DataMap.put(aStack, aData);
                    if (aData.hasValidMaterialData()) {
                        long tValidMaterialAmount = aData.mMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (aData.mMaterial.mAmount >= 0L ? aData.mMaterial.mAmount : 3628800L);
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tValidMaterialAmount += tMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (tMaterial.mAmount >= 0L ? tMaterial.mAmount : 3628800L);
                        }
                        if (tValidMaterialAmount < 3628800L) {
                            GT_ModHandler.addToRecyclerBlackList(aStack);
                        }
                    }
                    if (!mRunThroughTheList) break block12;
                    if (!GregTech_API.sLoadStarted) break block13;
                    mRunThroughTheList = false;
                    for (Map.Entry<ItemStack, ItemData> tEntry : sItemStack2DataMap.entrySet()) {
                        if (tEntry.getValue().hasValidPrefixData() && !tEntry.getValue().mPrefix.mAllowNormalRecycling) continue;
                        GT_RecipeRegistrator.registerMaterialRecycling(GT_ItemStack.internalCopyStack(tEntry.getKey()), tEntry.getValue());
                    }
                    break block13;
                }
                if (aData.hasValidPrefixData() && !aData.mPrefix.mAllowNormalRecycling) break block13;
                GT_RecipeRegistrator.registerMaterialRecycling(aStack, aData);
                break block13;
            }
            for (Object tObject : aData.mExtraData) {
                if (tData.mExtraData.contains(tObject)) continue;
                tData.mExtraData.add(tObject);
            }
        }
    }

    public static void removeItemData(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        sItemStack2DataMap.remove(aStack);
    }

    public static void addAssociation(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aBlackListed) {
        if (aPrefix == null || aMaterial == null || GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        if (Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                GT_OreDictUnificator.setItemData(GT_Utility.copyAmountAndMetaData(1, i, aStack), new ItemData(aPrefix, aMaterial, aBlackListed));
            }
        }
        GT_OreDictUnificator.setItemData(aStack, new ItemData(aPrefix, aMaterial, aBlackListed));
    }

    @Nullable
    public static ItemData getItemData(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData rData = sItemStack2DataMap.get(aStack);
        if (rData == null) {
            rData = sItemStack2DataMap.get(GT_ItemStack.internalCopyStack(aStack, true));
        }
        return rData;
    }

    @Nullable
    public static ItemData getAssociation(ItemStack aStack) {
        ItemData rData = GT_OreDictUnificator.getItemData(aStack);
        return rData != null && rData.hasValidPrefixMaterialData() ? rData : null;
    }

    public static boolean isItemStackInstanceOf(ItemStack aStack, Object aName) {
        if (GT_Utility.isStringInvalid(aName) || GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        for (ItemStack tOreStack : GT_OreDictUnificator.getOresImmutable(aName.toString())) {
            if (!GT_Utility.areStacksEqual(tOreStack, aStack, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemStackDye(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        for (Dyes tDye : Dyes.VALUES) {
            if (!GT_OreDictUnificator.isItemStackInstanceOf(aStack, tDye.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean registerOre(OrePrefixes aPrefix, Object aMaterial, ItemStack aStack) {
        return GT_OreDictUnificator.registerOre(aPrefix.get(aMaterial), aStack);
    }

    public static boolean registerOre(Object aName, ItemStack aStack) {
        if (aName == null || GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        String tName = aName.toString();
        if (GT_Utility.isStringInvalid(tName)) {
            return false;
        }
        for (ItemStack itemStack : GT_OreDictUnificator.getOresImmutable(tName)) {
            if (!GT_Utility.areStacksEqual(itemStack, aStack, true)) continue;
            return false;
        }
        ++isRegisteringOre;
        OreDictionary.registerOre((String)tName, (ItemStack)GT_Utility.copyAmount(1, aStack));
        --isRegisteringOre;
        return true;
    }

    public static boolean isRegisteringOres() {
        return isRegisteringOre > 0;
    }

    public static boolean isAddingOres() {
        return isAddingOre > 0;
    }

    public static void resetUnificationEntries() {
        for (ItemData tPrefixMaterial : sItemStack2DataMap.values()) {
            tPrefixMaterial.mUnificationTarget = null;
        }
    }

    public static ItemStack getGem(MaterialStack aMaterial) {
        return aMaterial == null ? null : GT_OreDictUnificator.getGem(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getGem(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GT_OreDictUnificator.getGem(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getGem(Materials aMaterial, long aMaterialAmount) {
        ItemStack rStack = null;
        if (aMaterialAmount >= 3628800L) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null) {
            if (aMaterialAmount * 2L % 3628800L == 0L || aMaterialAmount >= 58060800L) {
                rStack = GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, aMaterialAmount * 2L / 3628800L);
            }
            if (aMaterialAmount * 4L >= 3628800L) {
                rStack = GT_OreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, aMaterialAmount * 4L / 3628800L);
            }
        }
        return rStack;
    }

    public static ItemStack getDust(MaterialStack aMaterial) {
        return aMaterial == null ? null : GT_OreDictUnificator.getDust(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getDust(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GT_OreDictUnificator.getDust(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngot(MaterialStack aMaterial) {
        return aMaterial == null ? null : GT_OreDictUnificator.getIngot(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GT_OreDictUnificator.getIngot(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 32659200L == 0L && aMaterialAmount / 32659200L > 1L || aMaterialAmount >= 261273600L) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, aMaterialAmount / 32659200L);
        }
        if (rStack == null && (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GT_OreDictUnificator.get(OrePrefixes.nugget, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GT_OreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GT_OreDictUnificator.getDust(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(MaterialStack aMaterial) {
        ItemStack rStack = GT_OreDictUnificator.getIngot(aMaterial);
        if (rStack == null) {
            rStack = GT_OreDictUnificator.getDust(aMaterial);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GT_OreDictUnificator.getDust(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GT_OreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(MaterialStack aMaterial) {
        ItemStack rStack = GT_OreDictUnificator.getDust(aMaterial);
        if (rStack == null) {
            rStack = GT_OreDictUnificator.getIngot(aMaterial);
        }
        return rStack;
    }

    public static ArrayList<ItemStack> getOres(OrePrefixes aPrefix, Object aMaterial) {
        return GT_OreDictUnificator.getOres(aPrefix.get(aMaterial));
    }

    public static ArrayList<ItemStack> getOres(Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStringValid(aName)) {
            rList.addAll(OreDictionary.getOres((String)aName));
        }
        return rList;
    }

    public static List<ItemStack> getOresImmutable(@Nullable Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        return GT_Utility.isStringValid(aName) ? Collections.unmodifiableList(OreDictionary.getOres((String)aName)) : Collections.emptyList();
    }

    static {
        GregTech_API.sItemStackMappings.add(sItemStack2DataMap);
        GregTech_API.sItemStackMappings.add(sUnificationTable);
    }
}

