/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import gregtech.common.GT_Proxy;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Runnable_MachineBlockUpdate
implements Runnable {
    static final int SIZE_BITS_X = 26;
    static final int SIZE_BITS_Z = 26;
    static final int SIZE_BITS_Y = 12;
    static final long BITS_X = 0x3FFFFFFL;
    static final long BITS_Y = 4095L;
    static final long BITS_Z = 0x3FFFFFFL;
    static final int BIT_SHIFT_Z = 12;
    static final int BIT_SHIFT_X = 38;
    protected final int initialX;
    protected final int initialY;
    protected final int initialZ;
    protected final World world;
    protected final LongSet visited = new LongOpenHashSet();
    protected final LongArrayFIFOQueue tQueue = new LongArrayFIFOQueue();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(r);
        thread.setName("GT_MachineBlockUpdate");
        return thread;
    };
    protected static ExecutorService EXECUTOR_SERVICE;
    protected static boolean isEnabled;
    protected static final ThreadLocal<Boolean> perThreadEnable;

    static long asLong(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & 0x3FFFFFFL) << 38;
        l |= ((long)y & 0xFFFL) << 0;
        return l |= ((long)z & 0x3FFFFFFL) << 12;
    }

    public static int unpackLongX(long packedPos) {
        return (int)(packedPos << 0 >> 38);
    }

    public static int unpackLongY(long packedPos) {
        return (int)(packedPos << 52 >> 52);
    }

    public static int unpackLongZ(long packedPos) {
        return (int)(packedPos << 26 >> 38);
    }

    protected GT_Runnable_MachineBlockUpdate(World aWorld, int posX, int posY, int posZ) {
        this.world = aWorld;
        this.initialX = posX;
        this.initialY = posY;
        this.initialZ = posZ;
        long coords = GT_Runnable_MachineBlockUpdate.asLong(posX, posY, posZ);
        this.visited.add(coords);
        this.tQueue.enqueue(coords);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled() {
        isEnabled = true;
    }

    public static void setDisabled() {
        isEnabled = false;
    }

    public static void setEnabled(boolean isEnabled) {
        GT_Runnable_MachineBlockUpdate.isEnabled = isEnabled;
    }

    public static boolean isCurrentThreadEnabled() {
        return perThreadEnable.get();
    }

    public static void setCurrentThreadEnabled(boolean perThreadEnable) {
        GT_Runnable_MachineBlockUpdate.perThreadEnable.set(perThreadEnable);
    }

    public static void setMachineUpdateValues(World aWorld, int posX, int posY, int posZ) {
        if (GT_Runnable_MachineBlockUpdate.isEnabled() && GT_Runnable_MachineBlockUpdate.isCurrentThreadEnabled()) {
            EXECUTOR_SERVICE.submit(new GT_Runnable_MachineBlockUpdate(aWorld, posX, posY, posZ));
        }
    }

    public static void initExecutorService() {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() * 2 / 3), THREAD_FACTORY);
    }

    public static void shutdownExecutorService() {
        try {
            GT_Mod.GT_FML_LOGGER.info("Shutting down Machine block update executor service");
            EXECUTOR_SERVICE.shutdown();
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
                }
            }
        }
        catch (InterruptedException ie) {
            GT_Mod.GT_FML_LOGGER.error("Well this interruption got interrupted...", (Throwable)ie);
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well...", (Throwable)e);
            EXECUTOR_SERVICE.shutdownNow();
        }
        finally {
            GT_Mod.GT_FML_LOGGER.info("Leaving... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.tQueue.isEmpty()) {
                boolean isMachineBlock;
                TileEntity tTileEntity;
                long packedCoords = this.tQueue.dequeueLong();
                int posX = GT_Runnable_MachineBlockUpdate.unpackLongX(packedCoords);
                int posY = GT_Runnable_MachineBlockUpdate.unpackLongY(packedCoords);
                int posZ = GT_Runnable_MachineBlockUpdate.unpackLongZ(packedCoords);
                GT_Proxy.TICK_LOCK.lock();
                try {
                    tTileEntity = this.world.func_147438_o(posX, posY, posZ);
                    isMachineBlock = GregTech_API.isMachineBlock(this.world.func_147439_a(posX, posY, posZ), this.world.func_72805_g(posX, posY, posZ));
                }
                finally {
                    GT_Proxy.TICK_LOCK.unlock();
                }
                if (tTileEntity instanceof IMachineBlockUpdateable) {
                    ((IMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate();
                }
                if (this.visited.size() >= 5 && (!(tTileEntity instanceof IMachineBlockUpdateable) || !((IMachineBlockUpdateable)tTileEntity).isMachineBlockUpdateRecursive()) && !isMachineBlock) continue;
                for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[i];
                    long tCoords = GT_Runnable_MachineBlockUpdate.asLong(posX + side.offsetX, posY + side.offsetY, posZ + side.offsetZ);
                    if (!this.visited.add(tCoords)) continue;
                    this.tQueue.enqueue(tCoords);
                }
            }
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this update was broken... " + this.initialX + ", " + this.initialY + ", " + this.initialZ + ", mWorld={" + this.world.func_72827_u() + " @dimId " + this.world.field_73011_w.field_76574_g + "}", (Throwable)e);
        }
    }

    static {
        isEnabled = true;
        perThreadEnable = ThreadLocal.withInitial(() -> true);
    }
}

