/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import com.google.common.primitives.Ints;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.objects.overclockdescriber.EUNoOverclockDescriber;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUOverclockDescriber
extends EUNoOverclockDescriber {
    public EUOverclockDescriber(byte tier, int amperage) {
        super(tier, amperage);
    }

    @Override
    public GT_OverclockCalculator createCalculator(GT_OverclockCalculator template, GT_Recipe recipe) {
        return template.setEUt(Ints.saturatedCast((long)(GT_Values.V[this.tier] * (long)this.amperage)));
    }

    @Override
    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (!this.wasOverclocked(recipeInfo.calculator)) {
            super.drawEnergyInfoImpl(recipeInfo);
            return;
        }
        recipeInfo.drawText(GT_Utility.trans("153", "Usage: ") + this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GT_Utility.trans("154", "Voltage: ") + this.getVoltageString(recipeInfo.calculator));
        }
        if (GT_Mod.gregtechproxy.mNEIOriginalVoltage) {
            EUNoOverclockDescriber originalPower = new EUNoOverclockDescriber(this.tier, this.amperage);
            GT_OverclockCalculator originalPowerCalculator = GT_OverclockCalculator.ofNoOverclock(recipeInfo.recipe).calculate();
            recipeInfo.drawText(GT_Utility.trans("275", "Original usage: ") + originalPower.getEUtDisplay(originalPowerCalculator));
        }
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GT_Utility.trans("155", "Amperage: ") + this.getAmperageString(recipeInfo.calculator));
        }
    }

    @Override
    protected String getEUtWithoutTier(GT_OverclockCalculator calculator) {
        return this.decorateWithOverclockLabel(super.getEUtWithoutTier(calculator), calculator);
    }

    @Override
    protected String getEUtWithTier(GT_OverclockCalculator calculator) {
        return this.getEUtWithoutTier(calculator) + GT_Utility.getTierNameWithParentheses(calculator.getConsumption());
    }

    @Override
    protected String getVoltageString(GT_OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return this.decorateWithOverclockLabel(GT_Utility.formatNumbers(voltage) + " EU/t", calculator) + GT_Utility.getTierNameWithParentheses(voltage);
    }

    protected String decorateWithOverclockLabel(String s, GT_OverclockCalculator calculator) {
        if (this.wasOverclocked(calculator)) {
            s = s + " (OC)";
        }
        return s;
    }

    protected boolean wasOverclocked(GT_OverclockCalculator calculator) {
        return calculator.getPerformedOverclocks() > 0;
    }
}

