/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.blockupdate;

import appeng.api.util.WorldCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.objects.blockupdate.RandomCooldown;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@SideOnly(value=Side.CLIENT)
public class BlockUpdateHandler {
    public static final int MIN_UPDATE_COOLDOWN = 10;
    public static final int MAX_UPDATE_COOLDOWN = 20;
    public static final BlockUpdateHandler Instance = new BlockUpdateHandler();
    private HashMap<ChunkCoordIntPair, WorldCoord> blocksToUpdate = new HashMap();
    private HashMap<ChunkCoordIntPair, RandomCooldown> cooldowns = new HashMap();
    private World currWorld = null;
    private long internalTickCounter = 0L;

    private BlockUpdateHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void enqueueBlockUpdate(World world, WorldCoord pos) {
        EntityClientPlayerMP player = this.getPlayer();
        if (world != player.field_70170_p) {
            return;
        }
        this.ResetDataIfPlayerWorldChanged(player);
        this.blocksToUpdate.put(this.getBlockChunkCoords(world, pos), pos);
    }

    @SubscribeEvent
    public void OnClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.ResetDataIfPlayerWorldChanged(this.getPlayer());
        Iterator<Map.Entry<ChunkCoordIntPair, WorldCoord>> it = this.blocksToUpdate.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ChunkCoordIntPair, WorldCoord> entry = it.next();
            ChunkCoordIntPair chunkCoords = entry.getKey();
            WorldCoord blockCoords = entry.getValue();
            RandomCooldown cooldown = this.cooldowns.get(chunkCoords);
            if (cooldown == null) {
                cooldown = new RandomCooldown(10, 20);
                this.cooldowns.put(chunkCoords, cooldown);
            }
            if (!cooldown.hasPassed(this.internalTickCounter)) continue;
            this.currWorld.func_147471_g(blockCoords.x, blockCoords.y, blockCoords.z);
            cooldown.set(this.internalTickCounter);
            it.remove();
        }
        ++this.internalTickCounter;
    }

    private EntityClientPlayerMP getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void ResetDataIfPlayerWorldChanged(EntityClientPlayerMP player) {
        if (player == null) {
            return;
        }
        World playerWorld = player.field_70170_p;
        if (this.currWorld != playerWorld) {
            this.blocksToUpdate.clear();
            this.cooldowns.clear();
            this.currWorld = playerWorld;
        }
    }

    private ChunkCoordIntPair getBlockChunkCoords(World world, WorldCoord pos) {
        Chunk chunk = world.func_72938_d(pos.x, pos.z);
        return chunk.func_76632_l();
    }
}

