/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.schematics;

import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.BlockMetaComb;
import bloodasp.galacticgreg.api.Enums;
import bloodasp.galacticgreg.api.ISpaceObjectGenerator;
import bloodasp.galacticgreg.api.StructureInformation;
import bloodasp.galacticgreg.schematics.SpaceSchematic;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.Vec3;

public class SpaceSchematicWrapper
implements ISpaceObjectGenerator {
    private SpaceSchematic _mSchematic;
    private Vec3 _mCenter = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private List<StructureInformation> _mFinalizedStructure;

    public SpaceSchematicWrapper(SpaceSchematic pSchematic) {
        this._mSchematic = pSchematic;
    }

    public boolean isCalculated() {
        return this._mFinalizedStructure != null && this._mFinalizedStructure.size() > 0;
    }

    private void RecalculatePosition() {
        this._mFinalizedStructure = new ArrayList<StructureInformation>();
        for (SpaceSchematic.BaseStructureInfo bsi : this._mSchematic.coordInfo()) {
            try {
                String tModID = bsi.blockName.split(":")[0];
                String tBlockName = bsi.blockName.split(":")[1];
                Block tBlock = GameRegistry.findBlock((String)tModID, (String)tBlockName);
                if (tBlock != null) {
                    BlockMetaComb bmc = new BlockMetaComb(tBlock, bsi.blockMeta);
                    Vec3 tCenteredPos = this._mCenter.func_72441_c((double)bsi.posX, (double)bsi.posY, (double)bsi.posZ);
                    StructureInformation tnewSI = new StructureInformation(tCenteredPos, Enums.TargetBlockPosition.StructureBlock, bmc);
                    this._mFinalizedStructure.add(tnewSI);
                    continue;
                }
                GalacticGreg.Logger.warn("Block %s:%s could not be found. Schematic will be incomplete!", tModID, tBlockName);
            }
            catch (Exception e) {
                e.printStackTrace();
                GalacticGreg.Logger.error("Error while recalculating blocks position", new Object[0]);
            }
        }
    }

    @Override
    public Vec3 getCenterPoint() {
        return this._mCenter;
    }

    @Override
    public void setCenterPoint(int pX, int pY, int pZ) {
        this._mCenter = Vec3.func_72443_a((double)pX, (double)pY, (double)pZ);
    }

    @Override
    public void setCenterPoint(Vec3 pCenter) {
        this._mCenter = pCenter;
    }

    @Override
    public List<StructureInformation> getStructure() {
        return this._mFinalizedStructure;
    }

    @Override
    public void calculate() {
        this.RecalculatePosition();
    }

    @Override
    public void randomize(int pSizeMin, int pSizeMax) {
    }

    @Override
    public Enums.SpaceObjectType getType() {
        return Enums.SpaceObjectType.NonOreSchematic;
    }

    @Override
    public void reset() {
    }
}

