/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.util;

import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandHelper {
    public static final Random RAND = new Random();

    public static <T> T flipCoin(T a, T b) {
        return RandHelper.flipCoin(RAND, a, b);
    }

    public static <T> T flipCoin(Random random, T a, T b) {
        return random.nextBoolean() ? a : b;
    }

    public static <T> T chance(int chance, T a, T b) {
        return RandHelper.chance(RAND, chance, a, b);
    }

    public static <T> T chance(Random random, int chance, T a, T b) {
        return RandHelper.chance(random, chance) ? a : b;
    }

    public static boolean chance(int chance) {
        return RandHelper.chance(RAND, chance);
    }

    public static boolean chance(Random random, int chance) {
        if (chance > 100) {
            throw new IllegalArgumentException("Chance shouldn't be greater than 100. Provided: " + chance);
        }
        return random.nextInt(100) < chance;
    }

    @SafeVarargs
    public static <T> T chooseEqually(Random r, T ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Provided array 'items' shouldn't be empty!");
        }
        return items[r.nextInt(items.length)];
    }

    @SafeVarargs
    public static <T> T chooseEqually(T ... items) {
        return RandHelper.chooseEqually(RAND, items);
    }

    public static <T> T chooseEqually(Random r, List<T> items) {
        if (items.size() == 0) {
            throw new IllegalArgumentException("Provided array 'items' shouldn't be empty!");
        }
        return items.get(r.nextInt(items.size()));
    }

    public static <T> T chooseEqually(List<T> items) {
        return RandHelper.chooseEqually(RAND, items);
    }

    public static <T> T chooseEqually(Random r, Collection<T> items) {
        if (items.size() == 0) {
            throw new IllegalArgumentException("Provided array 'items' shouldn't be empty!");
        }
        int i = 0;
        int size = items.size();
        int selected = r.nextInt(size);
        for (T item : items) {
            if (i == selected) {
                return item;
            }
            ++i;
        }
        throw new IllegalArgumentException("Can't find randomly chosen element while iterating the collection.");
    }

    public static <T> T chooseEqually(Collection<T> items) {
        return RandHelper.chooseEqually(RAND, items);
    }
}

