/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.config.base;

import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.timecore.api.common.config.ConfigSection;

public class RewardConfig
extends ConfigSection {
    public int minItems;
    public int maxItems;
    public String defaultLootTable;
    private final HashMap<Integer, String> dimensionsConfigs = new HashMap();
    private final Defaults defaults;

    public RewardConfig(String parent, String key, String comment, Defaults defaults) {
        super(parent, key, comment);
        this.defaults = defaults;
    }

    @Override
    protected void init(Configuration config) {
        this.minItems = config.getInt("min_items", this.getCategoryName(), this.defaults.minItems, 0, 256, "Minimum amount of item stacks to be generated in chest.");
        this.maxItems = config.getInt("max_items", this.getCategoryName(), this.defaults.maxItems, 1, 256, "Maximum amount of item stacks to be generated in chest.");
        this.defaultLootTable = config.getString("default_loot_table", this.getCategoryName(), this.defaults.lootTable, "Name of the loot table, items from which will be generated in the chest of this stage. This can be adjusted per dimension in \"per_dim_configs\".");
        String[] perDimConfigs = config.getStringList("per_dim_configs", this.getCategoryName(), new String[0], "Here you can add different loot tables to each dimension. If dimension isn't in this list, then game will take default loot table for this stage.\nSyntax: <dimension_key>|<loottable_name>\n<loottable_name> - The loottable name for the chest in this stage.\nGeneral Example: [ \"0|minecraft:chests/simple_dungeon\" ]");
        this.parseDimConfigs(perDimConfigs);
    }

    public String getLootTable(World world) {
        String lootTable = this.dimensionsConfigs.get(world.field_73011_w.field_76574_g);
        return lootTable != null ? lootTable : this.defaultLootTable;
    }

    private void parseDimConfigs(String[] perDimConfigs) {
        this.dimensionsConfigs.clear();
        for (String entry : perDimConfigs) {
            String[] config = entry.split("\\|");
            for (int i = 0; i < config.length; ++i) {
                config[i] = config[i].trim();
            }
            if (config.length == 2) {
                int dimKey;
                try {
                    dimKey = Integer.parseInt(config[0]);
                }
                catch (NumberFormatException e) {
                    LootGames.LOGGER.error("Invalid dimension configs entry found: {}. Dimension id is not an Integer.  Skipping entry...", new Object[]{entry});
                    continue;
                }
                if (this.dimensionsConfigs.containsKey(dimKey)) {
                    LootGames.LOGGER.error("Invalid dimension configs entry found: {}. Dimension id is already defined. Skipping entry...", new Object[]{entry});
                    continue;
                }
                if (!config[1].isEmpty()) {
                    this.dimensionsConfigs.put(dimKey, config[1]);
                    continue;
                }
                LootGames.LOGGER.error("Invalid dimension configs entry found: {}. LootTable key must not be an empty string. Skipping entry...", new Object[]{entry});
                continue;
            }
            LootGames.LOGGER.error("Invalid dimension configs entry found: {}. Syntax is <dimension_key>|<loottable_key>.  Skipping entry...", new Object[]{entry});
        }
    }

    public static class Defaults {
        private final String lootTable;
        private final int minItems;
        private final int maxItems;

        public Defaults(String lootTable, int minItems, int maxItems) {
            this.lootTable = lootTable;
            this.minItems = minItems;
            this.maxItems = maxItems;
        }
    }

    public static class Names {
        public static final String MIN_ITEMS = "min_items";
        public static final String MAX_ITEMS = "max_items";
        public static final String DEFAULT_LOOT_TABLE = "default_loot_table";
        public static final String PER_DIM_CONFIGS = "per_dim_configs";
    }
}

