/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import galaxyspace.GalaxySpace;
import galaxyspace.core.item.block.GSItemBlockDesc;
import galaxyspace.core.tile.machine.TileEntityStorageModule;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorageModuleT3
extends BlockTileGC
implements GSItemBlockDesc.IBlockShiftDesc {
    public static final int STORAGE_MODULE_T3 = 0;
    public static final int STORAGE_MODULE_T4 = 8;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconOutput;
    private IIcon[] iconStorageModuleT3 = new IIcon[17];
    private IIcon[] iconStorageModuleT4 = new IIcon[17];

    public BlockStorageModuleT3(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c(assetName);
    }

    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var7 = var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof IMultiBlock) {
            ((IMultiBlock)var7).onDestroy(var7);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    public CreativeTabs func_149708_J() {
        return GalaxySpace.tabBlocks;
    }

    public int func_149645_b() {
        return GalaxySpace.proxy.getBlockRender((Block)this);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        int i;
        this.field_149761_L = iconRegister.func_94245_a("galaxyspace:overworld/machine");
        this.iconInput = iconRegister.func_94245_a("galaxyspace:overworld/machine_input");
        this.iconOutput = iconRegister.func_94245_a("galaxyspace:overworld/machine_output");
        this.iconMachineSide = iconRegister.func_94245_a("galaxyspace:overworld/machine_side");
        for (i = 0; i < this.iconStorageModuleT3.length; ++i) {
            this.iconStorageModuleT3[i] = iconRegister.func_94245_a("galaxyspace:overworld/storagemodule/module_t3_" + i);
        }
        for (i = 0; i < this.iconStorageModuleT4.length; ++i) {
            this.iconStorageModuleT4[i] = iconRegister.func_94245_a("galaxyspace:overworld/storagemodule/module_t4_" + i);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        int type = metadata & 4;
        int metaside = (metadata & 3) + 2;
        if (type != 0) {
            return this.func_149691_a(side, metadata);
        }
        if (side == 0 || side == 1) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.field_149761_L;
        }
        if (side == metaside) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.iconOutput;
        }
        if (side == (metaside ^ 1)) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.iconInput;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        int level = 0;
        if (tile instanceof TileEntityStorageModule) {
            level = ((TileEntityStorageModule)tile).scaledEnergyLevel;
        }
        if (metadata >= 8) {
            return this.iconStorageModuleT4[level];
        }
        return this.iconStorageModuleT3[level];
    }

    public IIcon func_149691_a(int side, int metadata) {
        int metaside = (metadata & 3) + 2;
        if (side == 0 || side == 1) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.field_149761_L;
        }
        if ((metadata & 4) != 0) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.iconMachineSide;
        }
        if (side == metaside) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.iconOutput;
        }
        if (side == (metaside ^ 1)) {
            if (metadata >= 8) {
                // empty if block
            }
            return this.iconInput;
        }
        if (metadata >= 8) {
            return this.iconStorageModuleT4[16];
        }
        return this.iconStorageModuleT3[16];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (!par1World.field_72995_K) {
            par5EntityPlayer.openGui((Object)GalaxySpace.instance, -1, par1World, x, y, z);
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        int tier = metadata / 8 + 1;
        return new TileEntityStorageModule(tier);
    }

    public ItemStack getEnergyStorageModule() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getEnergyStorageCluster() {
        return new ItemStack((Block)this, 1, 8);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getEnergyStorageModule());
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getDescription(int meta) {
        return null;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.StorageModule.desc");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

