/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.v2;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.crafting.v2.CraftingContext;
import appeng.crafting.v2.CraftingRequest;
import appeng.crafting.v2.resolvers.CraftableItemResolver;
import appeng.crafting.v2.resolvers.CraftingRequestResolver;
import appeng.crafting.v2.resolvers.CraftingTask;
import appeng.crafting.v2.resolvers.EmitableItemResolver;
import appeng.crafting.v2.resolvers.ExtractItemResolver;
import appeng.crafting.v2.resolvers.IgnoreMissingItemResolver;
import appeng.crafting.v2.resolvers.SimulateMissingItemResolver;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToLongBiFunction;
import org.apache.logging.log4j.Level;

public class CraftingCalculations {
    private static final ListMultimap<Class<? extends IAEStack<?>>, CraftingRequestResolver<?>> providers = ArrayListMultimap.create((int)2, (int)8);
    private static final ListMultimap<Class<? extends IAEStack<?>>, ToLongBiFunction<CraftingRequest<?>, Long>> byteAmountAdjusters = ArrayListMultimap.create((int)2, (int)8);

    public static <StackType extends IAEStack<StackType>> void registerProvider(CraftingRequestResolver<StackType> provider, Class<StackType> stackTypeClass) {
        providers.put(stackTypeClass, provider);
    }

    public static <StackType extends IAEStack<StackType>> void registerByteAmountAdjuster(ToLongBiFunction<CraftingRequest<StackType>, Long> adjuster, Class<StackType> stackTypeClass) {
        byteAmountAdjusters.put(stackTypeClass, adjuster);
    }

    public static <StackType extends IAEStack<StackType>> List<CraftingTask> tryResolveCraftingRequest(CraftingRequest<StackType> request, CraftingContext context) {
        ArrayList<CraftingTask> allTasks = new ArrayList<CraftingTask>(4);
        for (CraftingRequestResolver unsafeProvider : Multimaps.filterKeys(providers, key -> key.isAssignableFrom(request.stackTypeClass)).values()) {
            try {
                CraftingRequestResolver provider = unsafeProvider;
                List<CraftingTask> tasks = provider.provideCraftingRequestResolvers(request, context);
                allTasks.addAll(tasks);
            }
            catch (Exception t) {
                AELog.log(Level.WARN, t, "Error encountered when trying to generate the list of CraftingTasks for crafting {}", request.toString());
            }
        }
        allTasks.sort(CraftingTask.PRIORITY_COMPARATOR);
        return Collections.unmodifiableList(allTasks);
    }

    public static <StackType extends IAEStack<StackType>> long adjustByteCost(CraftingRequest<StackType> request, long byteCost) {
        Iterator iterator = Multimaps.filterKeys(byteAmountAdjusters, key -> key.isAssignableFrom(request.stackTypeClass)).values().iterator();
        while (iterator.hasNext()) {
            ToLongBiFunction unsafeAdjuster;
            ToLongBiFunction adjuster = unsafeAdjuster = (ToLongBiFunction)iterator.next();
            byteCost = adjuster.applyAsLong(request, byteCost);
        }
        return byteCost;
    }

    static {
        CraftingCalculations.registerProvider(new ExtractItemResolver(), IAEItemStack.class);
        CraftingCalculations.registerProvider(new SimulateMissingItemResolver(), IAEItemStack.class);
        CraftingCalculations.registerProvider(new SimulateMissingItemResolver(), IAEFluidStack.class);
        CraftingCalculations.registerProvider(new EmitableItemResolver(), IAEItemStack.class);
        CraftingCalculations.registerProvider(new CraftableItemResolver(), IAEItemStack.class);
        CraftingCalculations.registerProvider(new IgnoreMissingItemResolver(), IAEItemStack.class);
    }
}

