/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.recipes.IRecipeHandler;
import appeng.core.AELog;
import appeng.recipes.CustomRecipeConfig;
import appeng.recipes.loader.ConfigLoader;
import appeng.recipes.loader.JarLoader;
import appeng.recipes.loader.RecipeResourceCopier;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;

public class RecipeLoader
implements Runnable {
    private static final String ASSETS_RECIPE_PATH = "/assets/appliedenergistics2/recipes/";
    private static final String ASSETS_GTNH_RECIPE_PATH = "/assets/appliedenergistics2/GTNHRecipes/";
    @Nonnull
    private final IRecipeHandler handler;
    @Nonnull
    private final CustomRecipeConfig config;
    @Nonnull
    private final File recipeDirectory;

    public RecipeLoader(@Nonnull File recipeDirectory, @Nonnull CustomRecipeConfig config, @Nonnull IRecipeHandler handler) {
        this.recipeDirectory = (File)Preconditions.checkNotNull((Object)recipeDirectory);
        Preconditions.checkArgument((!recipeDirectory.isFile() ? 1 : 0) != 0);
        this.config = (CustomRecipeConfig)Preconditions.checkNotNull((Object)config);
        this.handler = (IRecipeHandler)Preconditions.checkNotNull((Object)handler);
    }

    @Override
    public final void run() {
        String recipesFolder = Loader.isModLoaded((String)"dreamcraft") ? ASSETS_GTNH_RECIPE_PATH : ASSETS_RECIPE_PATH;
        boolean useResourceFallBack = true;
        if (this.config.isEnabled()) {
            RecipeResourceCopier copier = new RecipeResourceCopier(recipesFolder.substring(1));
            File generatedRecipesDir = new File(this.recipeDirectory, "generated");
            File userRecipesDir = new File(this.recipeDirectory, "user");
            try {
                FileUtils.forceMkdir((File)generatedRecipesDir);
                FileUtils.forceMkdir((File)userRecipesDir);
                FileUtils.cleanDirectory((File)generatedRecipesDir);
                copier.copyTo(".recipe", generatedRecipesDir);
                copier.copyTo(".html", this.recipeDirectory);
                this.handler.parseRecipes(new ConfigLoader(generatedRecipesDir, userRecipesDir), "index.recipe");
                useResourceFallBack = false;
            }
            catch (IOException | URISyntaxException e) {
                AELog.debug(e);
            }
        }
        if (useResourceFallBack) {
            this.handler.parseRecipes(new JarLoader(recipesFolder), "index.recipe");
        }
    }
}

