/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.events.GuiScrollEvent;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.client.render.AppEngRenderItem;
import appeng.client.render.TranslatedRenderItem;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketSwapSlots;
import appeng.helpers.InventoryAction;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.INEI;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import codechicken.nei.guihook.GuiContainerManager;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class AEBaseGui
extends GuiContainer {
    private static boolean switchingGuis;
    private final List<InternalSlotME> meSlots = new LinkedList<InternalSlotME>();
    private final Set<Slot> drag_click = new HashSet<Slot>();
    public static final AppEngRenderItem aeRenderItem;
    public static final TranslatedRenderItem translatedRenderItem;
    private GuiScrollbar scrollBar = null;
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private ItemStack dbl_whichItem;
    private Slot bl_clicked;
    private boolean subGui = switchingGuis;
    private static boolean hasLwjgl3;

    public AEBaseGui(Container container) {
        super(container);
        switchingGuis = false;
    }

    protected static String join(Collection<String> toolTip, String delimiter) {
        Joiner joiner = Joiner.on((String)delimiter);
        return joiner.join(toolTip);
    }

    protected int getQty(GuiButton btn) {
        try {
            DecimalFormat df = new DecimalFormat("+#;-#");
            return df.parse(btn.field_146126_j).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public boolean isSubGui() {
        return this.subGui;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        List<Slot> slots = this.getInventorySlots();
        slots.removeIf(slot -> slot instanceof SlotME);
        for (InternalSlotME me : this.meSlots) {
            slots.add(new SlotME(me));
        }
    }

    private List<Slot> getInventorySlots() {
        return this.field_147002_h.field_75151_b;
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        super.func_73863_a(mouseX, mouseY, btn);
        for (Object c : this.field_146292_n) {
            if (!(c instanceof ITooltip)) continue;
            this.handleTooltip(mouseX, mouseY, (ITooltip)c);
        }
    }

    protected void handleTooltip(int mouseX, int mouseY, ITooltip tooltip) {
        int x = tooltip.xPos();
        int y = tooltip.yPos();
        if (x < mouseX && x + tooltip.getWidth() > mouseX && tooltip.isVisible() && y < mouseY && y + tooltip.getHeight() > mouseY) {
            String msg;
            if (y < 15) {
                y = 15;
            }
            if ((msg = tooltip.getMessage()) != null && !msg.isEmpty()) {
                this.drawTooltip(x + 11, y + 4, 0, msg);
            }
        }
    }

    public void drawTooltip(int x, int y, int forceWidth, String message) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        String[] lines = message.split("\n");
        if (lines.length > 0) {
            ScaledResolution scaledresolution;
            int top;
            int left;
            int width = 0;
            for (left = 0; left < lines.length; ++left) {
                top = this.field_146289_q.func_78256_a(lines[left]);
                if (top <= width) continue;
                width = top;
            }
            left = x + 12;
            top = y - 12;
            int height = 8;
            if (lines.length > 1) {
                height += 2 + (lines.length - 1) * 10;
            }
            if (top + height + 6 > (scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d)).func_78328_b()) {
                top = scaledresolution.func_78328_b() - height - 6;
            }
            if (forceWidth > 0) {
                width = forceWidth;
            }
            if (left + width + 6 > scaledresolution.func_78326_a()) {
                left = scaledresolution.func_78326_a() - width - 6;
            }
            this.field_73735_i = 300.0f;
            AEBaseGui.field_146296_j.field_77023_b = 300.0f;
            int color1 = -267386864;
            this.func_73733_a(left - 3, top - 4, left + width + 3, top - 3, -267386864, -267386864);
            this.func_73733_a(left - 3, top + height + 3, left + width + 3, top + height + 4, -267386864, -267386864);
            this.func_73733_a(left - 3, top - 3, left + width + 3, top + height + 3, -267386864, -267386864);
            this.func_73733_a(left - 4, top - 3, left - 3, top + height + 3, -267386864, -267386864);
            this.func_73733_a(left + width + 3, top - 3, left + width + 4, top + height + 3, -267386864, -267386864);
            int color2 = 0x505000FF;
            int color3 = 1344798847;
            this.func_73733_a(left - 3, top - 3 + 1, left - 3 + 1, top + height + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(left + width + 2, top - 3 + 1, left + width + 3, top + height + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(left - 3, top - 3, left + width + 3, top - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(left - 3, top + height + 2, left + width + 3, top + height + 3, 1344798847, 1344798847);
            for (int var13 = 0; var13 < lines.length; ++var13) {
                String var14 = lines[var13];
                var14 = var13 == 0 ? '\u00a7' + Integer.toHexString(15) + var14 : "\u00a77" + var14;
                this.field_146289_q.func_78261_a(var14, left, top, -1);
                if (var13 == 0) {
                    top += 2;
                }
                top += 10;
            }
            this.field_73735_i = 0.0f;
            AEBaseGui.field_146296_j.field_77023_b = 0.0f;
        }
        GL11.glPopAttrib();
    }

    public void addTexturedRectToTesselator(float x0, float y0, float x1, float y1, float zLevel, float u0, float v0, float u1, float v1) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78374_a((double)x0, (double)y1, (double)this.field_73735_i, (double)u0, (double)v1);
        tessellator.func_78374_a((double)x1, (double)y1, (double)this.field_73735_i, (double)u1, (double)v1);
        tessellator.func_78374_a((double)x1, (double)y0, (double)this.field_73735_i, (double)u1, (double)v0);
        tessellator.func_78374_a((double)x0, (double)y0, (double)this.field_73735_i, (double)u0, (double)v0);
    }

    public void drawTextured9PatchRect(int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH) {
        float uvScale = 0.00390625f;
        float x03 = x;
        float x13 = (float)x + (float)textureW / 3.0f;
        float x23 = (float)(x + width) - (float)textureW / 3.0f;
        float x33 = x + width;
        float y03 = y;
        float y13 = (float)y + (float)textureH / 3.0f;
        float y23 = (float)(y + height) - (float)textureH / 3.0f;
        float y33 = y + height;
        float u03 = 0.00390625f * (float)textureX;
        float u13 = 0.00390625f * ((float)textureX + (float)textureW / 3.0f);
        float u23 = 0.00390625f * ((float)textureX + (float)(2 * textureW) / 3.0f);
        float u33 = 0.00390625f * (float)(textureX + textureW);
        float v03 = 0.00390625f * (float)textureY;
        float v13 = 0.00390625f * ((float)textureY + (float)textureH / 3.0f);
        float v23 = 0.00390625f * ((float)textureY + (float)(2 * textureH) / 3.0f);
        float v33 = 0.00390625f * (float)(textureY + textureH);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        this.addTexturedRectToTesselator(x03, y03, x13, y13, this.field_73735_i, u03, v03, u13, v13);
        this.addTexturedRectToTesselator(x13, y03, x23, y13, this.field_73735_i, u13, v03, u23, v13);
        this.addTexturedRectToTesselator(x23, y03, x33, y13, this.field_73735_i, u23, v03, u33, v13);
        this.addTexturedRectToTesselator(x03, y13, x13, y23, this.field_73735_i, u03, v13, u13, v23);
        this.addTexturedRectToTesselator(x13, y13, x23, y23, this.field_73735_i, u13, v13, u23, v23);
        this.addTexturedRectToTesselator(x23, y13, x33, y23, this.field_73735_i, u23, v13, u33, v23);
        this.addTexturedRectToTesselator(x03, y23, x13, y33, this.field_73735_i, u03, v23, u13, v33);
        this.addTexturedRectToTesselator(x13, y23, x23, y33, this.field_73735_i, u13, v23, u23, v33);
        this.addTexturedRectToTesselator(x23, y23, x33, y33, this.field_73735_i, u23, v23, u33, v33);
        tessellator.func_78381_a();
    }

    protected final void func_146979_b(int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getScrollBar() != null) {
            this.getScrollBar().draw(this);
        }
        this.drawFG(ox, oy, x, y);
    }

    public abstract void drawFG(int var1, int var2, int var3, int var4);

    protected final void func_146976_a(float f, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(ox, oy, x, y);
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            OptionalSlotFake fs;
            if (!(slot instanceof OptionalSlotFake) || !(fs = (OptionalSlotFake)slot).renderDisabled()) continue;
            if (fs.isEnabled()) {
                this.func_73729_b(ox + fs.field_75223_e - 1, oy + fs.field_75221_f - 1, fs.getSourceX() - 1, fs.getSourceY() - 1, 18, 18);
                continue;
            }
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GL11.glEnable((int)3042);
            this.func_73729_b(ox + fs.field_75223_e - 1, oy + fs.field_75221_f - 1, fs.getSourceX() - 1, fs.getSourceY() - 1, 18, 18);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopAttrib();
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.drag_click.clear();
        if (btn == 1) {
            for (Object o : this.field_146292_n) {
                GuiButton guibutton = (GuiButton)o;
                if (!guibutton.func_146116_c(this.field_146297_k, xCoord, yCoord)) continue;
                super.func_73864_a(xCoord, yCoord, 0);
                return;
            }
        }
        if (this.getScrollBar() != null) {
            this.getScrollBar().click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146273_a(int x, int y, int c, long d) {
        Slot slot = this.getSlot(x, y);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.getScrollBar() != null) {
            this.getScrollBar().click(this, x - this.field_147003_i, y - this.field_147009_r);
        }
        if (slot instanceof SlotFake && itemstack != null) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (Slot dr : this.drag_click) {
                    PacketInventoryAction p = new PacketInventoryAction(c == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_75222_d, 0L);
                    NetworkHandler.instance.sendToServer(p);
                }
            }
        } else if (slot instanceof SlotDisconnected) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                if (itemstack != null) {
                    for (Slot dr : this.drag_click) {
                        if (slot.func_75211_c() != null) continue;
                        InventoryAction action = InventoryAction.SPLIT_OR_PLACE_SINGLE;
                        PacketInventoryAction p = new PacketInventoryAction(action, dr.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                        NetworkHandler.instance.sendToServer(p);
                    }
                } else if (AEBaseGui.func_146272_n()) {
                    for (Slot dr : this.drag_click) {
                        InventoryAction action = null;
                        if (slot.func_75211_c() != null) {
                            action = InventoryAction.SHIFT_CLICK;
                        }
                        if (action == null) continue;
                        PacketInventoryAction p = new PacketInventoryAction(action, dr.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                        NetworkHandler.instance.sendToServer(p);
                    }
                }
            }
        } else {
            super.func_146273_a(x, y, c, d);
        }
    }

    protected void func_146984_a(Slot slot, int slotIdx, int ctrlDown, int mouseButton) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (mouseButton == 3) {
            if ((slot instanceof OptionalSlotFake || slot instanceof SlotFakeCraftingMatrix) && slot.func_75216_d()) {
                InventoryAction action = InventoryAction.SET_PATTERN_VALUE;
                AEItemStack stack = AEItemStack.create(slot.func_75211_c());
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
                NetworkHandler.instance.sendToServer(p);
                return;
            }
        } else if (slot instanceof SlotFake) {
            InventoryAction action;
            InventoryAction inventoryAction = action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (slot instanceof SlotPatternTerm) {
            if (mouseButton == 6) {
                return;
            }
            try {
                NetworkHandler.instance.sendToServer(((SlotPatternTerm)slot).getRequest(AEBaseGui.func_146272_n()));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        } else if (slot instanceof SlotCraftingTerm) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = null;
            action = AEBaseGui.func_146272_n() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (Keyboard.isKeyDown((int)57) && this.enableSpaceClicking() && !(slot instanceof SlotPatternTerm)) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = this.getInventorySlots().size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryAction action = null;
            switch (mouseButton) {
                case 0: {
                    ItemStack heldStack = player.field_71071_by.func_70445_o();
                    if (slot.func_75211_c() == null && heldStack != null) {
                        action = InventoryAction.SPLIT_OR_PLACE_SINGLE;
                        break;
                    }
                    if (slot.func_75211_c() == null || heldStack != null && heldStack.field_77994_a > 1) break;
                    action = InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case 3: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PacketInventoryAction p = new PacketInventoryAction(action, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                NetworkHandler.instance.sendToServer(p);
            }
            return;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (mouseButton) {
                case 0: {
                    action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || player.field_71071_by.func_70445_o() != null) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case 3: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, this.getInventorySlots().size(), 0L);
                NetworkHandler.instance.sendToServer(p);
            }
            return;
        }
        if (!this.disableShiftClick && AEBaseGui.func_146272_n()) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem == null || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 150L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot != null ? (slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : null) : null;
            } else if (this.dbl_whichItem != null) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !inventorySlot.func_75216_d() || inventorySlot.field_75224_c != slot.field_75224_c || !Container.func_94527_a((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.func_146984_a(inventorySlot, inventorySlot.field_75222_d, ctrlDown, 1);
                }
            }
            this.disableShiftClick = false;
        }
        super.func_146984_a(slot, slotIdx, ctrlDown, mouseButton);
    }

    protected boolean func_146983_a(int keyCode) {
        Slot theSlot;
        try {
            theSlot = (Slot)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((Object)this), (String[])new String[]{"theSlot", "field_147006_u", "f"});
        }
        catch (Throwable t) {
            return false;
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (keyCode != this.field_146297_k.field_71474_y.field_151456_ac[j].func_151463_i()) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv() || s.func_82869_a(((AEBaseContainer)this.field_147002_h).getPlayerInv().field_70458_d)) continue;
                    return false;
                }
                if (theSlot.func_75219_a() == 64) {
                    this.func_146984_a(theSlot, theSlot.field_75222_d, j, 2);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv()) continue;
                    NetworkHandler.instance.sendToServer(new PacketSwapSlots(s.field_75222_d, theSlot.field_75222_d));
                    return true;
                }
            }
        }
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.subGui = true;
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public abstract void drawBG(int var1, int var2, int var3, int var4);

    public void func_146274_d() {
        int y;
        int x;
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0) {
            return;
        }
        if (!hasLwjgl3) {
            wheel = wheel > 0 ? (int)Platform.ceilDiv(wheel, 120L) : -((int)Platform.ceilDiv(-wheel, 120L));
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new GuiScrollEvent(this, x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1, wheel))) {
            return;
        }
        if (!this.mouseWheelEvent(x, y, wheel) && this.getScrollBar() != null) {
            GuiScrollbar scrollBar = this.getScrollBar();
            if (x > this.field_147003_i && y - this.field_147009_r > scrollBar.getTop() && x <= this.field_147003_i + this.field_146999_f && y - this.field_147009_r <= scrollBar.getTop() + scrollBar.getHeight()) {
                this.getScrollBar().wheel(wheel);
            }
        }
    }

    protected boolean mouseWheelEvent(int x, int y, int wheel) {
        IAEItemStack item;
        if (!AEBaseGui.func_146272_n()) {
            return false;
        }
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotME && (item = ((SlotME)slot).getAEStack()) != null) {
            ((AEBaseContainer)this.field_147002_h).setTargetStack(item);
            InventoryAction direction = wheel > 0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = Math.abs(wheel);
            int inventorySize = this.getInventorySlots().size();
            for (int h = 0; h < times; ++h) {
                PacketInventoryAction p = new PacketInventoryAction(direction, inventorySize, 0L);
                NetworkHandler.instance.sendToServer(p);
            }
        }
        return true;
    }

    protected boolean enableSpaceClicking() {
        return true;
    }

    public void bindTexture(String base, String file) {
        ResourceLocation loc = new ResourceLocation(base, "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public void drawItem(int x, int y, ItemStack is) {
        this.field_73735_i = 100.0f;
        AEBaseGui.field_146296_j.field_77023_b = 100.0f;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)101.0f);
        RenderHelper.func_74520_c();
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, is, x, y);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-101.0f);
        GL11.glPopAttrib();
        AEBaseGui.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected String getGuiDisplayName(String in) {
        return this.hasCustomInventoryName() ? this.getInventoryName() : in;
    }

    private boolean hasCustomInventoryName() {
        if (this.field_147002_h instanceof AEBaseContainer) {
            return ((AEBaseContainer)this.field_147002_h).getCustomName() != null;
        }
        return false;
    }

    private String getInventoryName() {
        return ((AEBaseContainer)this.field_147002_h).getCustomName();
    }

    private void drawSlot(Slot s) {
        if (s instanceof SlotME || s instanceof SlotFake) {
            IAEItemStack stack = Platform.getAEStackInSlot(s);
            if (s instanceof SlotFake && stack != null && stack.getStackSize() == 1L) {
                this.safeDrawSlot(s);
                return;
            }
            RenderItem pIR = this.setItemRender(aeRenderItem);
            try {
                if (!this.isPowered()) {
                    this.field_73735_i = 100.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 100.0f;
                    GL11.glDisable((int)2896);
                    AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)GuiColors.ItemSlotOverlayUnpowered.getColor());
                    GL11.glEnable((int)2896);
                    this.field_73735_i = 0.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 0.0f;
                } else {
                    aeRenderItem.setAeStack(Platform.getAEStackInSlot(s));
                    this.drawAESlot(s);
                }
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            }
            this.setItemRender(pIR);
            return;
        }
        try {
            ItemStack is = s.func_75211_c();
            if (s instanceof AppEngSlot) {
                AppEngSlot aes = (AppEngSlot)s;
                if ((((AppEngSlot)s).renderIconWithItem() || is == null) && ((AppEngSlot)s).shouldDisplay() && aes.getIcon() >= 0) {
                    this.bindTexture("guis/states.png");
                    GL11.glPushAttrib((int)1048575);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    try {
                        int uv_y = (int)Math.floor(aes.getIcon() / 16);
                        int uv_x = aes.getIcon() - uv_y * 16;
                        GL11.glEnable((int)3042);
                        GL11.glDisable((int)2896);
                        GL11.glEnable((int)3553);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        float par1 = aes.field_75223_e;
                        float par2 = aes.field_75221_f;
                        float par3 = uv_x * 16;
                        float par4 = uv_y * 16;
                        tessellator.func_78382_b();
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon());
                        float f1 = 0.00390625f;
                        float f = 0.00390625f;
                        float par6 = 16.0f;
                        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + 16.0f), (double)this.field_73735_i, (double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + 16.0f) * 0.00390625f));
                        float par5 = 16.0f;
                        tessellator.func_78374_a((double)(par1 + 16.0f), (double)(par2 + 16.0f), (double)this.field_73735_i, (double)((par3 + 16.0f) * 0.00390625f), (double)((par4 + 16.0f) * 0.00390625f));
                        tessellator.func_78374_a((double)(par1 + 16.0f), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + 16.0f) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f));
                        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f));
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
                        tessellator.func_78381_a();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GL11.glPopAttrib();
                }
            }
            if (is != null && s instanceof AppEngSlot) {
                if (((AppEngSlot)s).getIsValid() == AppEngSlot.hasCalculatedValidness.NotAvailable) {
                    boolean isValid;
                    boolean bl = isValid = s.func_75214_a(is) || s instanceof SlotOutput || s instanceof AppEngCraftingSlot || s instanceof SlotDisabled || s instanceof SlotInaccessible || s instanceof SlotFake || s instanceof SlotRestrictedInput || s instanceof SlotDisconnected;
                    if (isValid && s instanceof SlotRestrictedInput) {
                        try {
                            isValid = ((SlotRestrictedInput)s).isValid(is, (World)this.field_146297_k.field_71441_e);
                        }
                        catch (Exception err) {
                            AELog.debug(err);
                        }
                    }
                    ((AppEngSlot)s).setIsValid(isValid ? AppEngSlot.hasCalculatedValidness.Valid : AppEngSlot.hasCalculatedValidness.Invalid);
                }
                if (((AppEngSlot)s).getIsValid() == AppEngSlot.hasCalculatedValidness.Invalid) {
                    this.field_73735_i = 100.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 100.0f;
                    GL11.glDisable((int)2896);
                    AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)GuiColors.ItemSlotOverlayInvalid.getColor());
                    GL11.glEnable((int)2896);
                    this.field_73735_i = 0.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 0.0f;
                }
            }
            if (s instanceof AppEngSlot) {
                ((AppEngSlot)s).setDisplay(true);
                this.drawMCSlot(s);
            } else {
                this.safeDrawSlot(s);
            }
            return;
        }
        catch (Exception err) {
            AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            this.safeDrawSlot(s);
            return;
        }
    }

    public void drawMCSlot(Slot slotIn) {
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        String s = null;
        GL11.glEnable((int)2929);
        GuiContainerManager.getManager().renderSlotUnderlay(slotIn);
        AEBaseGui.translatedRenderItem.field_77023_b = 100.0f;
        translatedRenderItem.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, i, j);
        AEBaseGui.translatedRenderItem.field_77023_b = 200.0f;
        translatedRenderItem.renderItemOverlayIntoGUI(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, i, j, s, slotIn instanceof OptionalSlotRestrictedInput ? AEConfig.instance.getTerminalFontSize() : null);
        GuiContainerManager.getManager().renderSlotOverlay(slotIn);
        AEBaseGui.translatedRenderItem.field_77023_b = 0.0f;
    }

    public void drawAESlot(Slot slotIn) {
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        String s = null;
        this.field_73735_i = 100.0f;
        AEBaseGui.field_146296_j.field_77023_b = 100.0f;
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, i, j);
        AEBaseGui.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
        aeRenderItem.renderItemOverlayIntoGUI(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, i, j, s, slotIn);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
    }

    private RenderItem setItemRender(RenderItem item) {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI)) {
            return ((INEI)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.NEI)).setItemRender(item);
        }
        RenderItem ri = field_146296_j;
        field_146296_j = item;
        return ri;
    }

    protected boolean isPowered() {
        return true;
    }

    private void safeDrawSlot(Slot s) {
        try {
            GuiContainer.class.getDeclaredMethod("func_146977_a_original", Slot.class).invoke((Object)this, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public void bindTexture(ResourceLocation loc) {
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public void func_146977_a(Slot s) {
        this.drawSlot(s);
    }

    protected GuiScrollbar getScrollBar() {
        return this.scrollBar;
    }

    protected void setScrollBar(GuiScrollbar myScrollBar) {
        this.scrollBar = myScrollBar;
    }

    protected List<InternalSlotME> getMeSlots() {
        return this.meSlots;
    }

    public static final synchronized boolean isSwitchingGuis() {
        return switchingGuis;
    }

    public static final synchronized void setSwitchingGuis(boolean switchingGuis) {
        AEBaseGui.switchingGuis = switchingGuis;
    }

    protected void addItemTooltip(ItemStack is, List<String> lineList) {
        if (AEBaseGui.func_146272_n()) {
            List l = is.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            if (!l.isEmpty()) {
                l.remove(0);
            }
            lineList.addAll(l);
        } else {
            lineList.add(GuiText.HoldShiftForTooltip.getLocal());
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        super.func_73730_a(startX, endX, y, color);
    }

    public void func_73728_b(int x, int startY, int endY, int color) {
        super.func_73728_b(x, startY, endY, color);
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void func_146285_a(ItemStack itemIn, int x, int y) {
        super.func_146285_a(itemIn, x, y);
    }

    public void func_146279_a(String tabName, int mouseX, int mouseY) {
        super.func_146279_a(tabName, mouseX, mouseY);
    }

    public void drawHoveringText(List<String> textLines, int x, int y) {
        super.func_146283_a(textLines, x, y);
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        super.drawHoveringText(textLines, x, y, font);
    }

    public boolean isMouseOverRect(int left, int top, int right, int bottom, int pointX, int pointY) {
        return super.func_146978_c(left, top, right, bottom, pointX, pointY);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    static {
        aeRenderItem = new AppEngRenderItem();
        translatedRenderItem = new TranslatedRenderItem();
        hasLwjgl3 = Loader.isModLoaded((String)"lwjgl3ify");
    }
}

