/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.processingLoaders;

import com.github.bartimaeusnek.bartworks.API.recipe.BartWorksRecipeMaps;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.BioCultureLoader;
import com.github.bartimaeusnek.bartworks.common.loaders.BioItemList;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.BW_NonMeta_MaterialItems;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.AddSomeRecipes;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.LoadItemContainers;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AdditionalRecipes {
    private static void runBWRecipes() {
        if (ConfigHandler.BioLab) {
            FluidStack[] easyFluids;
            BioData DNA;
            FluidStack[] dnaFluid = new FluidStack[]{Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)1000) : Materials.Biomass.getFluid(1000L)};
            for (ItemStack stack : BioItemList.getAllPetriDishes()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
                if (DNA == null) continue;
                ItemStack Detergent = BioItemList.getOther(1);
                ItemStack DNAFlask = BioItemList.getDNASampleFlask(null);
                ItemStack EthanolCell = Materials.Ethanol.getCells(1);
                BartWorksRecipeMaps.bioLabRecipes.addFakeRecipe(false, new ItemStack[]{stack, DNAFlask, Detergent, EthanolCell}, new ItemStack[]{BioItemList.getDNASampleFlask(BioDNA.convertDataToDNA(DNA)), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)Materials.Empty, (long)1L)}, (Object)BioItemList.mBioLabParts[0], new int[]{DNA.getChance(), 10000}, new FluidStack[]{FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}, null, 500, BW_Util.getMachineVoltageFromTier(3 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllDNASampleFlasks()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p());
                if (DNA == null) continue;
                ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)Outp, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)Outp, (String)DNA.getName());
                BartWorksRecipeMaps.bioLabRecipes.addFakeRecipe(false, new ItemStack[]{stack, FluidLoader.BioLabFluidCells[0], FluidLoader.BioLabFluidCells[3], ItemList.Tool_DataOrb.get(1L, new Object[0])}, new ItemStack[]{Outp, ItemList.Cell_Empty.get(2L, new Object[0])}, (Object)BioItemList.mBioLabParts[1], new int[]{DNA.getChance(), 10000}, dnaFluid, null, 500, BW_Util.getMachineVoltageFromTier(4 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllPlasmidCells()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p());
                if (DNA == null) continue;
                ItemStack inp = ItemList.Tool_DataOrb.get(0L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)inp, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)inp, (String)DNA.getName());
                ItemStack inp2 = ItemList.Tool_DataOrb.get(0L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)inp2, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)inp2, (String)BioCultureLoader.BIO_DATA_BETA_LACMATASE.getName());
                BartWorksRecipeMaps.bioLabRecipes.addFakeRecipe(false, new ItemStack[]{FluidLoader.BioLabFluidCells[1], BioItemList.getPlasmidCell(null), inp, inp2}, new ItemStack[]{stack, ItemList.Cell_Empty.get(1L, new Object[0])}, (Object)BioItemList.mBioLabParts[2], new int[]{DNA.getChance(), 10000}, dnaFluid, null, 500, BW_Util.getMachineVoltageFromTier(4 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllPetriDishes()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
                BioData Plasmid = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("Plasmid"));
                if (Objects.equals(DNA.getName(), Plasmid.getName())) continue;
                BartWorksRecipeMaps.bioLabRecipes.addFakeRecipe(true, new ItemStack[]{BioItemList.getPetriDish(BioCulture.getBioCulture(DNA.getName())), BioItemList.getPlasmidCell(BioPlasmid.convertDataToPlasmid(Plasmid)), FluidLoader.BioLabFluidCells[2]}, new ItemStack[]{stack, ItemList.Cell_Empty.get(1L, new Object[0])}, (Object)BioItemList.mBioLabParts[3], new int[]{Plasmid.getChance(), 10000}, new FluidStack[]{FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}, null, 500, (int)TierEU.RECIPE_LuV, 0);
            }
            ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            Behaviour_DataOrb.setDataTitle((ItemStack)Outp, (String)"DNA Sample");
            Behaviour_DataOrb.setDataName((ItemStack)Outp, (String)"Any DNA");
            BartWorksRecipeMaps.bioLabRecipes.addFakeRecipe(false, new ItemStack[]{BioItemList.getPetriDish(null), BioItemList.getOther(4), ItemList.Circuit_Chip_Stemcell.get(2L, new Object[0]), Outp}, new ItemStack[]{BioItemList.getPetriDish(null).func_151001_c("The Culture made from DNA")}, (Object)BioItemList.mBioLabParts[4], new int[]{7500, 10000}, new FluidStack[]{new FluidStack(dnaFluid[0].getFluid(), 8000)}, null, 500, (int)TierEU.RECIPE_LuV, 0);
            for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
                for (BioCulture bioCulture : BioCulture.BIO_CULTURE_ARRAY_LIST) {
                    if (!bioCulture.isBreedable() || bioCulture.getTier() != 0) continue;
                    BartWorksRecipeMaps.bacterialVatRecipes.addRecipe(new GT_Recipe(true, new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1), new ItemStack(Items.field_151102_aT, 64)}, null, (Object)BioItemList.getPetriDish(bioCulture), null, new FluidStack[]{fluidStack}, new FluidStack[]{new FluidStack(bioCulture.getFluid(), 10)}, 1000, (int)TierEU.RECIPE_HV, 0));
                    BartWorksRecipeMaps.bioLabRecipes.addRecipe(new GT_Recipe(false, new ItemStack[]{BioItemList.getPetriDish(null), fluidStack.equals((Object)Materials.Water.getFluid(1000L)) ? Materials.Water.getCells(1) : (ItemStack)GT_Utility.getContainersFromFluid((FluidStack)GT_ModHandler.getDistilledWater((long)1000L)).get(0)}, new ItemStack[]{BioItemList.getPetriDish(bioCulture), Materials.Empty.getCells(1)}, null, new int[]{bioCulture.getChance(), 10000}, new FluidStack[]{new FluidStack(bioCulture.getFluid(), 1000)}, null, 500, (int)TierEU.RECIPE_HV, 0));
                }
            }
        }
        List<Pair> liquidFuels = Arrays.asList(ImmutablePair.of((Object)Materials.PhosphoricAcid, (Object)36), ImmutablePair.of((Object)Materials.DilutedHydrochloricAcid, (Object)14), ImmutablePair.of((Object)Materials.HypochlorousAcid, (Object)30), ImmutablePair.of((Object)Materials.HydrofluoricAcid, (Object)40), ImmutablePair.of((Object)Materials.HydrochloricAcid, (Object)28), ImmutablePair.of((Object)Materials.NitricAcid, (Object)24), ImmutablePair.of((Object)Materials.Mercury, (Object)32), ImmutablePair.of((Object)Materials.DilutedSulfuricAcid, (Object)9), ImmutablePair.of((Object)Materials.SulfuricAcid, (Object)18), ImmutablePair.of((Object)Materials.AceticAcid, (Object)11), ImmutablePair.of((Object)WerkstoffLoader.FormicAcid.getBridgeMaterial(), (Object)40));
        for (Pair fuel : liquidFuels) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{((Materials)fuel.getLeft()).getCells(1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).metadata(GT_RecipeConstants.FUEL_VALUE, (Object)((Integer)fuel.getRight())).addTo(BartWorksRecipeMaps.acidGenFuels);
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cellMolten, (Object)Materials.Redstone, (long)1L)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).metadata(GT_RecipeConstants.FUEL_VALUE, (Object)10).addTo(BartWorksRecipeMaps.acidGenFuels);
    }

    public static void run() {
        int i;
        AdditionalRecipes.runBWRecipes();
        GT_Values.RA.addImplosionRecipe(WerkstoffLoader.RawAdemicSteel.get(OrePrefixes.dust), 4, WerkstoffLoader.AdemicSteel.get(OrePrefixes.dust), null);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.YttriumOxide.get(OrePrefixes.dustSmall, 2), WerkstoffLoader.Thorianit.get(OrePrefixes.dustSmall, 2), Materials.Glass.getMolten(144L), null, new ItemStack(ItemRegistry.bw_glasses[0], 1, 12), null, 800, (int)TierEU.RECIPE_IV, 3663);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified)}).itemOutputs(new ItemStack[]{WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), Materials.Thorium.getDust(1), Materials.Thorium.getDust(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dust)}).outputChances(new int[]{7000, 1300, 700, 600, 300, 100}).duration(400).eut((int)TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.sifterRecipes);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 9), Materials.Aluminium.getDust(4), null, null, Materials.Thorium.getDust(3), Materials.Aluminiumoxide.getDust(10), 1000);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 3), Materials.Magnesium.getDust(2), null, null, Materials.Thorium.getDust(1), Materials.Magnesia.getDust(4), 1000);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.crushed), ItemList.Crop_Drop_Thorium.get(9L, new Object[0]), Materials.Water.getFluid(1000L), Materials.Thorium.getMolten(144L), WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified, 4), 96, 24);
        GT_Values.RA.addBlastRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Quartzite, (long)40L), Materials.Amethyst.getDust(10), GT_Values.NF, GT_Values.NF, WerkstoffLoader.Prasiolite.get(OrePrefixes.gemFlawed, 20), GT_Values.NI, 800, (int)TierEU.RECIPE_MV, 500);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Quartzite, (long)40L)}).itemOutputs(new ItemStack[]{Materials.Amethyst.getDust(10)}).duration(800).eut(0).metadata(GT_RecipeConstants.ADDITIVE_AMOUNT, (Object)6).addTo((IRecipeMap)RecipeMaps.primitiveBlastRecipes);
        GT_Values.RA.addChemicalRecipe(Materials.Yttrium.getDust(2), GT_Utility.getIntegratedCircuit((int)5), Materials.Oxygen.getGas(3000L), GT_Values.NF, WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust, 5), 4096, (int)TierEU.RECIPE_LV);
        RecipeMaps.blastFurnaceRecipes.addRecipe(false, new ItemStack[]{WerkstoffLoader.Zirconium.get(OrePrefixes.dust, 10), WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust, 0)}, new ItemStack[]{WerkstoffLoader.CubicZirconia.get(OrePrefixes.gemFlawed, 40)}, null, null, new FluidStack[]{Materials.Oxygen.getGas(20000L)}, null, 57600, (int)TierEU.RECIPE_HV, 2953);
        GT_Values.RA.addBlastRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushed, (Object)Materials.Lead, (long)10L), GT_Utility.getIntegratedCircuit((int)17), GT_Values.NF, GT_Values.NF, Materials.Lead.getIngots(10), Materials.Tellurium.getNuggets(20), 800, (int)TierEU.RECIPE_MV, 722);
        GT_Values.RA.addFusionReactorRecipe(Materials.Plutonium.getMolten(48L), Materials.Beryllium.getMolten(48L), WerkstoffLoader.Californium.getMolten(48), 240, 49152, 480000000);
        GT_Values.RA.addFusionReactorRecipe(WerkstoffLoader.Californium.getMolten(32), WerkstoffLoader.Calcium.getMolten(720), WerkstoffLoader.Oganesson.getFluidOrGas(720), 420, 49152, 600000000);
        GT_Values.RA.addDistillationTowerRecipe(Materials.LiquidAir.getFluid(100000000L), new FluidStack[]{Materials.Nitrogen.getGas(78084000L), Materials.Oxygen.getGas(20946000L), Materials.Argon.getGas(934000L), Materials.CarbonDioxide.getGas(40700L), WerkstoffLoader.Neon.getFluidOrGas(1818), Materials.Helium.getGas(524L), Materials.Methane.getGas(180L), WerkstoffLoader.Krypton.getFluidOrGas(114), Materials.Hydrogen.getGas(55L), WerkstoffLoader.Xenon.getFluidOrGas(9)}, null, 7500, (int)TierEU.RECIPE_EV);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemChipped, 9)}).outputChances(new int[]{9000}).fluidInputs(new FluidStack[]{WerkstoffLoader.Neon.getFluidOrGas(1000)}).duration(4500).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.autoclaveRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem)}).fluidInputs(new FluidStack[]{WerkstoffLoader.Krypton.getFluidOrGas(1000)}).duration(4500).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.autoclaveRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Sugar.getDustSmall(21), Materials.Calcium.getDustTiny(1), Materials.Magnesium.getDustTiny(1), Materials.Potassium.getDustTiny(1), Materials.Sodium.getDustTiny(4), Materials.Phosphor.getDustTiny(1)}).outputChances(new int[]{10000, 10000, 1000, 10000, 1000, 1000}).fluidInputs(new FluidStack[]{Materials.Milk.getFluid(10000L)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(8832L)}).duration(50).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        Fluid solderIndalloy = FluidRegistry.getFluid((String)"molten.indalloy140") != null ? FluidRegistry.getFluid((String)"molten.indalloy140") : FluidRegistry.getFluid((String)"molten.solderingalloy");
        Fluid solderUEV = FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") != null ? FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") : FluidRegistry.getFluid((String)"molten.solderingalloy");
        RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), ItemList.NandChip.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeSMD.get(4L, new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get(4L, new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get(4L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(4)}, null, null, new FluidStack[]{Materials.SolderingAlloy.getMolten(36L)}, null, 750, (int)TierEU.RECIPE_LV, -200));
        for (i = 1; i <= 4; ++i) {
            RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), BW_Meta_Items.getNEWCIRCUITS().getStack(i + 3), ItemList.Circuit_Parts_DiodeSMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get((long)((i + 1) * 4), new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(i + 4)}, null, null, new FluidStack[]{Materials.SolderingAlloy.getMolten((long)((i + 1) * 36))}, null, (i + 1) * 750, BW_Util.getMachineVoltageFromTier(i + 1), -200));
        }
        for (i = 5; i <= 6; ++i) {
            RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), BW_Meta_Items.getNEWCIRCUITS().getStack(i + 3), ItemList.Circuit_Parts_DiodeASMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_CapacitorASMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_TransistorASMD.get((long)((i + 1) * 4), new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(i + 4)}, null, null, new FluidStack[]{new FluidStack(solderIndalloy, (i + 1) * 36)}, null, (i + 1) * 750, BW_Util.getMachineVoltageFromTier(i + 1), -200));
        }
        RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemExquisite, 1), BW_Meta_Items.getNEWCIRCUITS().getStack(10), ItemList.Circuit_Parts_DiodeASMD.get(52L, new Object[0]), ItemList.Circuit_Parts_CapacitorASMD.get(52L, new Object[0]), ItemList.Circuit_Parts_TransistorASMD.get(52L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(11)}, null, null, new FluidStack[]{new FluidStack(solderIndalloy, 288)}, null, 12000, BW_Util.getMachineVoltageFromTier(8), -200));
        RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemExquisite, 1), BW_Meta_Items.getNEWCIRCUITS().getStack(11), ItemList.Circuit_Parts_DiodeASMD.get(56L, new Object[0]), ItemList.Circuit_Parts_CapacitorASMD.get(56L, new Object[0]), ItemList.Circuit_Parts_TransistorASMD.get(56L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(12)}, null, null, new FluidStack[]{new FluidStack(solderUEV, 324)}, null, 13500, BW_Util.getMachineVoltageFromTier(9), -200));
        for (i = 9; i <= 10; ++i) {
            RecipeMaps.circuitAssemblerRecipes.add(new GT_Recipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemExquisite, 1), BW_Meta_Items.getNEWCIRCUITS().getStack(i + 3), ItemList.Circuit_Parts_DiodeXSMD.get((long)((i + 6) * 4), new Object[0]), ItemList.Circuit_Parts_CapacitorXSMD.get((long)((i + 6) * 4), new Object[0]), ItemList.Circuit_Parts_TransistorXSMD.get((long)((i + 6) * 4), new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(i + 4)}, null, null, new FluidStack[]{new FluidStack(solderUEV, (i + 1) * 36)}, null, (i + 1) * 1500, BW_Util.getMachineVoltageFromTier(i + 1), -200));
        }
        RecipeMaps.smallNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.bolt)}, new ItemStack[0], null, null, null, 0, 0, 12500);
        RecipeMaps.largeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stick)}, new ItemStack[0], null, null, null, 0, 0, 62500);
        RecipeMaps.hugeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)}, new ItemStack[0], null, null, null, 0, 0, 125000);
        RecipeMaps.extremeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stick)}, new ItemStack[0], null, null, null, 0, 0, 31250);
        RecipeMaps.ultraHugeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)}, new ItemStack[0], null, null, null, 0, 0, 125000);
        LoadItemContainers.run();
        GT_Values.RA.addCannerRecipe(ItemList.Large_Fluid_Cell_TungstenSteel.get(1L, new Object[0]), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 3), BW_NonMeta_MaterialItems.TiberiumCell_1.get(1L, new Object[0]), null, 30, 16);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_1.get(2L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.TungstenSteel, (long)4L), BW_NonMeta_MaterialItems.TiberiumCell_2.get(1L, new Object[0]), 100, 400);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_1.get(4L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)6L), BW_NonMeta_MaterialItems.TiberiumCell_4.get(1L, new Object[0]), 150, 400);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_2.get(2L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.TungstenSteel, (long)4L), BW_NonMeta_MaterialItems.TiberiumCell_4.get(1L, new Object[0]), 100, 400);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemList.NaquadahCell_1.get(32L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64)}, null, BW_NonMeta_MaterialItems.TheCoreCell.get(1L, new Object[0]), 100, (int)TierEU.RECIPE_LuV);
        GregTech_API.sAfterGTPostload.add(new AddSomeRecipes());
    }
}

