/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API.recipe;

import codechicken.nei.PositionedStack;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.gtnewhorizons.modularui.api.math.Alignment;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BacterialVatFrontend
extends RecipeMapFrontend {
    public BacterialVatFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter((INEISpecialInfoFormatter)new BacterialVatSpecialValueFormatter()));
    }

    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.input.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemInputTooltip(currentTip, pStack);
    }

    protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.output.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemOutputTooltip(currentTip, pStack);
    }

    protected void drawNEIOverlayForInput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    protected void drawNEIOverlayForOutput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    private void drawFluidOverlay(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
        if (stack.isFluid()) {
            this.drawNEIOverlayText("+", (PositionedStack)stack, this.colorOverride.getTextColorOrDefault("nei_overlay_yellow", 16635957), 0.5f, true, Alignment.TopRight);
            return;
        }
        super.drawNEIOverlayForOutput(stack);
    }

    private static class BacterialVatSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private BacterialVatSpecialValueFormatter() {
        }

        public List<String> format(RecipeDisplayInfo recipeInfo) {
            int[] tSpecialA = GT_TileEntity_BioVat.specialValueUnpack(recipeInfo.recipe.mSpecialValue);
            String glassTier = StatCollector.func_74837_a((String)"nei.biovat.0.name", (Object[])new Object[]{tSpecialA[0]});
            String sievert = tSpecialA[2] == 1 ? StatCollector.func_74837_a((String)"nei.biovat.1.name", (Object[])new Object[]{tSpecialA[3]}) : StatCollector.func_74837_a((String)"nei.biovat.2.name", (Object[])new Object[]{tSpecialA[3]});
            return Arrays.asList(glassTier, sievert);
        }
    }
}

