/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.events;

import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.ObjectBlock;
import chylex.hee.mechanics.compendium.objects.ObjectItem;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import chylex.hee.mechanics.compendium.util.KnowledgeObservation;
import chylex.hee.mechanics.misc.PlayerDataHandler;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C19CompendiumData;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;

public final class CompendiumEvents
implements PlayerDataHandler.IExtendedPropertyInitializer<PlayerCompendiumData> {
    private static final String playerPropertyIdentifier = "HardcoreEnderExpansion~Compendium";
    private static final byte byteZero = 0;
    private static final byte byteOne = 1;
    private static final ObjectBlock.BlockMetaWrapper bmwReuse = new ObjectBlock.BlockMetaWrapper(Blocks.field_150350_a, 0);
    private static final KnowledgeObservation observationReuse = new KnowledgeObservation();
    private static CompendiumEvents instance;
    private final TObjectByteHashMap<UUID> playerTickLimiter = new TObjectByteHashMap();

    public static void register() {
        if (instance == null) {
            instance = new CompendiumEvents();
            MinecraftForge.EVENT_BUS.register((Object)instance);
            FMLCommonHandler.instance().bus().register((Object)instance);
            PlayerDataHandler.registerProperty(playerPropertyIdentifier, instance);
        }
    }

    public static PlayerCompendiumData getPlayerData(EntityPlayer player) {
        return (PlayerCompendiumData)player.getExtendedProperties(playerPropertyIdentifier);
    }

    public static KnowledgeObject<ObjectBlock> getBlockObject(ItemStack is) {
        CompendiumEvents.bmwReuse.block = ((ItemBlock)is.func_77973_b()).field_150939_a;
        CompendiumEvents.bmwReuse.metadata = (byte)is.func_77960_j();
        return KnowledgeObject.getObject(bmwReuse);
    }

    public static KnowledgeObservation getObservation(EntityPlayer player) {
        observationReuse.setEmpty();
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)((player.field_70170_p.field_72995_K ? 1.5 : 0.0) + player.field_70121_D.field_72338_b + (double)player.func_70047_e() - (player.func_70093_af() ? 0.08 : 0.0)), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70040_Z();
        MovingObjectPosition mopBlock = player.field_70170_p.func_72901_a(posVec.func_72441_c(0.0, 0.0, 0.0), posVec.func_72441_c(lookVec.field_72450_a * 10.0, lookVec.field_72448_b * 10.0, lookVec.field_72449_c * 10.0), true);
        double distBlock = mopBlock != null && mopBlock.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK ? MathUtil.distance((double)mopBlock.field_72311_b + 0.5 - posVec.field_72450_a, (double)mopBlock.field_72312_c + 0.5 - posVec.field_72448_b, (double)mopBlock.field_72309_d + 0.5 - posVec.field_72449_c) : Double.MAX_VALUE;
        double bbX = posVec.field_72450_a + lookVec.field_72450_a * 5.0;
        double bbY = posVec.field_72448_b + lookVec.field_72448_b * 5.0;
        double bbZ = posVec.field_72449_c + lookVec.field_72449_c * 5.0;
        List list = player.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(bbX - 6.0), (double)(bbY - 6.0), (double)(bbZ - 6.0), (double)(bbX + 6.0), (double)(bbY + 6.0), (double)(bbZ + 6.0)));
        Vec3 interceptVec = posVec.func_72441_c(lookVec.field_72450_a * 10.0, lookVec.field_72448_b * 10.0, lookVec.field_72449_c * 10.0);
        Entity tracedEntity = null;
        double distEntity = Double.MAX_VALUE;
        for (Entity entity : list) {
            double d;
            double size;
            MovingObjectPosition mop;
            if (entity == player || (mop = entity.field_70121_D.func_72314_b(size = (double)entity.func_70111_Y(), size, size).func_72327_a(posVec, interceptVec)) == null) continue;
            double dist = posVec.func_72438_d(mop.field_72307_f);
            if (!(d < distEntity)) continue;
            distEntity = dist;
            tracedEntity = entity;
        }
        if (distBlock < distEntity && mopBlock != null) {
            BlockPosM tmpPos = BlockPosM.tmp(mopBlock.field_72311_b, mopBlock.field_72312_c, mopBlock.field_72309_d);
            ObjectBlock.BlockMetaWrapper wrapper = new ObjectBlock.BlockMetaWrapper(tmpPos.getBlock((IBlockAccess)player.field_70170_p), tmpPos.getMetadata((IBlockAccess)player.field_70170_p));
            observationReuse.setBlock(KnowledgeObject.getObject(wrapper));
        } else if (tracedEntity != null) {
            if (tracedEntity instanceof EntityLiving) {
                observationReuse.setMob(KnowledgeObject.getObject((EntityLiving)tracedEntity));
            } else if (tracedEntity instanceof EntityItem) {
                ItemStack is = ((EntityItem)tracedEntity).func_92059_d();
                if (is.func_77973_b() instanceof ItemBlock) {
                    observationReuse.setBlock(CompendiumEvents.getBlockObject(is));
                } else {
                    observationReuse.setItem(KnowledgeObject.getObject(is.func_77973_b()));
                }
            }
        }
        return observationReuse;
    }

    private CompendiumEvents() {
    }

    @Override
    public PlayerCompendiumData createNew(Entity entity) {
        return new PlayerCompendiumData();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        PacketPipeline.sendToPlayer(e.player, new C19CompendiumData(e.player));
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedOutEvent e) {
        this.playerTickLimiter.remove((Object)e.player.func_146103_bH().getId());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.START || e.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = e.player;
        if (this.playerTickLimiter.adjustOrPutValue((Object)player.func_146103_bH().getId(), (byte)1, (byte)1) >= 7) {
            Stopwatch.timeAverage("CompendiumEvents - look tracing", 100);
            this.playerTickLimiter.put((Object)player.func_146103_bH().getId(), (byte)0);
            CompendiumEvents.getObservation(player).discover(player);
            Stopwatch.finish("CompendiumEvents - look tracing");
            Stopwatch.timeAverage("CompendiumEvents - inventory", 100);
            for (ItemStack is : player.field_71071_by.field_70462_a) {
                if (is == null) continue;
                this.discoverItemStack(player, is);
            }
            Stopwatch.finish("CompendiumEvents - inventory");
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent e) {
        if (e.player != null && !e.player.field_70170_p.field_72995_K) {
            this.discoverItemStack(e.player, e.pickedUp.func_92059_d());
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        if (e.player != null && !e.player.field_70170_p.field_72995_K) {
            this.discoverItemStack(e.player, e.crafting);
        }
    }

    private void discoverItemStack(EntityPlayer player, ItemStack is) {
        if (is.func_77973_b() instanceof ItemBlock) {
            CompendiumEvents.bmwReuse.block = ((ItemBlock)is.func_77973_b()).field_150939_a;
            CompendiumEvents.bmwReuse.metadata = (byte)is.func_77960_j();
            KnowledgeObject<ObjectBlock> obj = KnowledgeObject.getObject(bmwReuse);
            if (obj != null) {
                observationReuse.setBlock(obj).discover(player);
            }
        } else {
            KnowledgeObject<ObjectItem> obj = KnowledgeObject.getObject(is.func_77973_b());
            if (obj != null) {
                observationReuse.setItem(obj).discover(player);
            }
        }
    }
}

