/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.MessageSendBadge;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageRequestBadge
extends MessageToServer {
    private UUID playerId;

    public MessageRequestBadge() {
    }

    public MessageRequestBadge(UUID player) {
        this.playerId = player;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeUUID(this.playerId);
    }

    @Override
    public void readData(DataIn data) {
        this.playerId = data.readUUID();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        String badge = ServerUtilitiesUniverseData.getBadge(Universe.get(), this.playerId);
        new MessageSendBadge(this.playerId, badge).sendTo(player);
    }
}

