/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageJourneyMapUpdate;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageJourneyMapRequest
extends MessageToServer {
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;

    public MessageJourneyMapRequest() {
    }

    public MessageJourneyMapRequest(int minX, int maxX, int minZ, int maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.minX);
        data.writeVarInt(this.maxX);
        data.writeVarInt(this.minZ);
        data.writeVarInt(this.maxZ);
    }

    @Override
    public void readData(DataIn data) {
        this.minX = data.readVarInt();
        this.maxX = data.readVarInt();
        this.minZ = data.readVarInt();
        this.maxZ = data.readVarInt();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (ServerUtilitiesConfig.world.chunk_claiming && PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.journeymap.enable")) {
            new MessageJourneyMapUpdate(this.minX, this.maxX, this.minZ, this.maxZ, (EntityPlayer)player).sendTo(player);
        }
    }
}

