/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.math;

import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.MathUtils;
import serverutils.lib.math.TeleporterDimPos;

public final class BlockDimPos {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int dim;

    @Nullable
    public static BlockDimPos fromIntArray(@Nullable int[] ai) {
        return ai == null || ai.length < 3 ? null : new BlockDimPos(ai[0], ai[1], ai[2], ai.length > 3 ? ai[3] : 0);
    }

    public BlockDimPos(int x, int y, int z, int d) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dim = d;
    }

    public BlockDimPos(double x, double y, double z, int d) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), d);
    }

    public BlockDimPos(ChunkCoordinates p, int d) {
        this(p.field_71574_a, p.field_71572_b, p.field_71573_c, d);
    }

    public BlockDimPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u + 0.1, entity.field_70161_v, entity.field_71093_bK);
    }

    public BlockDimPos(ICommandSender sender) {
        this(sender.func_82114_b(), sender.func_130014_f_().field_73011_w.field_76574_g);
    }

    public BlockDimPos(EntityPlayer player) {
        this(player.func_82114_b(), player.func_130014_f_().field_73011_w.field_76574_g);
    }

    public int[] toIntArray() {
        return new int[]{this.posX, this.posY, this.posZ, this.dim};
    }

    public String toString() {
        return "[" + this.dim + '@' + this.posX + ',' + this.posY + ',' + this.posZ + ']';
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof BlockDimPos) {
            return this.equalsPos((BlockDimPos)o);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dim;
    }

    public Vec3 toVec() {
        return Vec3.func_72443_a((double)((double)this.posX + 0.5), (double)((double)this.posY + 0.5), (double)((double)this.posZ + 0.5));
    }

    public ChunkDimPos toChunkPos() {
        return new ChunkDimPos(MathUtils.chunk(this.posX), MathUtils.chunk(this.posZ), this.dim);
    }

    public BlockDimPos copy() {
        return new BlockDimPos(this.posX, this.posY, this.posZ, this.dim);
    }

    public boolean equalsPos(BlockDimPos p) {
        return p == this || p.dim == this.dim && p.posX == this.posX && p.posY == this.posY && p.posZ == this.posZ;
    }

    public BlockDimPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockDimPos(this.posX + x, this.posY + y, this.posZ + z, this.dim);
    }

    public TeleporterDimPos teleporter() {
        return TeleporterDimPos.of((double)this.posX + 0.5, (double)this.posY + 0.1, (double)this.posZ + 0.5, this.dim);
    }
}

