/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.io;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.lib.icon.Icon;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.JsonUtils;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntArrayList;

public class DataIn {
    public static final Deserializer<String> STRING = DataIn::readString;
    public static final Deserializer<Integer> INT = DataIn::readInt;
    public static final Deserializer<Boolean> BOOLEAN = DataIn::readBoolean;
    public static final Deserializer<UUID> UUID = DataIn::readUUID;
    public static final Deserializer<Vec3> BLOCK_POS = DataIn::readPos;
    public static final Deserializer<BlockDimPos> BLOCK_DIM_POS = DataIn::readDimPos;
    public static final Deserializer<JsonElement> JSON = DataIn::readJson;
    public static final Deserializer<IChatComponent> TEXT_COMPONENT = DataIn::readTextComponent;
    public static final Deserializer<ResourceLocation> RESOURCE_LOCATION = DataIn::readResourceLocation;
    public static final Deserializer<ItemStack> ITEM_STACK = DataIn::readItemStack;
    public static final Deserializer<ChunkDimPos> CHUNK_DIM_POS = DataIn::readChunkDimPos;
    public static final Deserializer<ChunkCoordIntPair> CHUNK_POS = data -> {
        int x = data.readVarInt();
        int z = data.readVarInt();
        return new ChunkCoordIntPair(x, z);
    };
    private final ByteBuf byteBuf;

    public DataIn(ByteBuf io) {
        this.byteBuf = io;
    }

    public int getPosition() {
        return this.byteBuf.readerIndex();
    }

    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    public byte readByte() {
        return this.byteBuf.readByte();
    }

    public void readBytes(byte[] bytes, int off, int len) {
        this.byteBuf.readBytes(bytes, off, len);
    }

    public void readBytes(byte[] bytes) {
        this.readBytes(bytes, 0, bytes.length);
    }

    public short readUnsignedByte() {
        return this.byteBuf.readUnsignedByte();
    }

    public short readShort() {
        return this.byteBuf.readShort();
    }

    public int readUnsignedShort() {
        return this.byteBuf.readUnsignedShort();
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public long readLong() {
        return this.byteBuf.readLong();
    }

    public float readFloat() {
        return this.byteBuf.readFloat();
    }

    public double readDouble() {
        return this.byteBuf.readDouble();
    }

    public String readString() {
        int s = this.readVarInt();
        if (s == 0) {
            return "";
        }
        byte[] bytes = new byte[s];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public <T> Collection<T> readCollection(@Nullable Collection<T> collection, Deserializer<T> deserializer) {
        int num;
        if (collection != null) {
            collection.clear();
        }
        if ((num = this.readVarInt()) == 0) {
            return collection == null ? Collections.emptyList() : collection;
        }
        int size = Math.abs(num);
        if (collection == null) {
            boolean list;
            boolean bl = list = num > 0;
            if (size == 1) {
                return list ? Collections.singletonList(deserializer.read(this)) : Collections.singleton(deserializer.read(this));
            }
            Collection<Object> collection2 = collection = list ? new ArrayList(size) : new HashSet(size);
        }
        while (--size >= 0) {
            collection.add(deserializer.read(this));
        }
        return collection;
    }

    public <T> Collection<T> readCollection(Deserializer<T> deserializer) {
        return this.readCollection(null, deserializer);
    }

    public <K, V> Map<K, V> readMap(@Nullable Map<K, V> map, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        int num;
        if (map != null) {
            map.clear();
        }
        if ((num = this.readVarInt()) == 0) {
            return map == null ? Collections.emptyMap() : map;
        }
        int size = Math.abs(num);
        if (map == null) {
            boolean linked;
            boolean bl = linked = num < 0;
            if (keyDeserializer == INT) {
                map = (Map)CommonUtils.cast(linked ? new HashMap(size) : new Int2ObjectOpenHashMap(size));
            } else {
                Map map2 = map = linked ? new LinkedHashMap(size) : new HashMap(size);
            }
        }
        while (--size >= 0) {
            K key = keyDeserializer.read(this);
            V value = valueDeserializer.read(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> Map<K, V> readMap(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.readMap(null, keyDeserializer, valueDeserializer);
    }

    public ItemStack readItemStack() {
        int id = this.readVarInt();
        if (id == 0) {
            return InvUtils.EMPTY_STACK;
        }
        Item item = Item.func_150899_d((int)id);
        if (item == null) {
            return InvUtils.EMPTY_STACK;
        }
        int size = this.readVarInt();
        int meta = this.readVarInt();
        ItemStack stack = new ItemStack(item, size, meta);
        stack.func_77963_c(this.readNBT());
        return stack;
    }

    @Nullable
    public NBTTagCompound readNBT() {
        int i = this.byteBuf.readerIndex();
        byte b0 = this.byteBuf.readByte();
        if (b0 == 0) {
            return null;
        }
        this.byteBuf.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(this.byteBuf), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException ex) {
            throw new EncoderException((Throwable)ex);
        }
    }

    @Nullable
    public NBTBase readNBTBase() {
        NBTTagByte nBTTagByte;
        switch (this.readByte()) {
            case 0: {
                nBTTagByte = null;
                break;
            }
            case 1: {
                nBTTagByte = new NBTTagByte(this.readByte());
                break;
            }
            case 2: {
                nBTTagByte = new NBTTagShort(this.readShort());
                break;
            }
            case 3: {
                nBTTagByte = new NBTTagInt(this.readInt());
                break;
            }
            case 4: {
                nBTTagByte = new NBTTagLong(this.readLong());
                break;
            }
            case 5: {
                nBTTagByte = new NBTTagFloat(this.readFloat());
                break;
            }
            case 6: {
                nBTTagByte = new NBTTagDouble(this.readDouble());
                break;
            }
            case 8: {
                nBTTagByte = new NBTTagString(this.readString());
                break;
            }
            case 10: {
                nBTTagByte = this.readNBT();
                break;
            }
            default: {
                nBTTagByte = this.readNBT().func_74781_a("_");
            }
        }
        return nBTTagByte;
    }

    public Vec3 readPos() {
        int x = this.readVarInt();
        int y = this.readVarInt();
        int z = this.readVarInt();
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public BlockDimPos readDimPos() {
        int d = this.readVarInt();
        int x = this.readVarInt();
        int y = this.readVarInt();
        int z = this.readVarInt();
        return new BlockDimPos(x, y, z, d);
    }

    public ChunkDimPos readChunkDimPos() {
        int x = this.readVarInt();
        int z = this.readVarInt();
        int d = this.readVarInt();
        return new ChunkDimPos(x, z, d);
    }

    public UUID readUUID() {
        long msb = this.readLong();
        long lsb = this.readLong();
        return new UUID(msb, lsb);
    }

    public ResourceLocation readResourceLocation() {
        return new ResourceLocation(this.readString());
    }

    public JsonElement readJson() {
        switch (this.readUnsignedByte()) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 1: {
                JsonObject json = new JsonObject();
                for (Map.Entry<String, JsonElement> entry : this.readMap(STRING, JSON).entrySet()) {
                    json.add(entry.getKey(), entry.getValue());
                }
                return json;
            }
            case 2: {
                JsonArray json = new JsonArray();
                for (JsonElement json1 : this.readCollection(JSON)) {
                    json.add(json1);
                }
                return json;
            }
            case 3: {
                String s = this.readString();
                return s.isEmpty() ? JsonUtils.JSON_EMPTY_STRING : new JsonPrimitive(s);
            }
            case 4: {
                return JsonUtils.JSON_ZERO;
            }
            case 5: {
                return JsonUtils.JSON_TRUE;
            }
            case 6: {
                return JsonUtils.JSON_FALSE;
            }
            case 7: {
                return new JsonPrimitive((Number)this.readVarLong());
            }
            case 8: {
                return new JsonPrimitive((Number)Float.valueOf(this.readFloat()));
            }
            case 9: {
                return new JsonPrimitive((Number)this.readDouble());
            }
            case 10: {
                return JsonUtils.JSON_EMPTY_STRING;
            }
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public IChatComponent readTextComponent() {
        return JsonUtils.deserializeTextComponent(this.readJson());
    }

    public Icon readIcon() {
        return Icon.getIcon(this.readJson());
    }

    public IntArrayList readIntList() {
        int size = this.readVarInt();
        if (size == 0) {
            return new IntArrayList();
        }
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(this.readInt());
        }
        return list;
    }

    public int readVarInt() {
        short s;
        short b = this.readByte();
        switch (b) {
            case 121: {
                s = this.readByte();
                break;
            }
            case 122: {
                s = this.readShort();
                break;
            }
            case 123: {
                s = (short)this.readInt();
                break;
            }
            default: {
                s = b;
            }
        }
        return s;
    }

    public long readVarLong() {
        long l;
        byte b = this.readByte();
        switch (b) {
            case 121: {
                l = this.readByte();
                break;
            }
            case 122: {
                l = this.readShort();
                break;
            }
            case 123: {
                l = this.readInt();
                break;
            }
            case 124: {
                l = this.readLong();
                break;
            }
            default: {
                l = b;
            }
        }
        return l;
    }

    @FunctionalInterface
    public static interface Deserializer<T> {
        public T read(DataIn var1);
    }
}

