/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.PanelScrollBar;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.MutableColor4I;
import serverutils.lib.io.Bits;
import serverutils.lib.util.misc.MouseButton;

public class GuiEditConfig
extends GuiBase {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static final Comparator<ConfigValueInstance> COMPARATOR = (o1, o2) -> {
        int i = o1.getGroup().getPath().compareToIgnoreCase(o2.getGroup().getPath());
        if (i == 0) {
            i = Integer.compare(o1.getOrder(), o2.getOrder());
        }
        if (i == 0) {
            i = o1.getDisplayName().func_150260_c().compareToIgnoreCase(o2.getDisplayName().func_150260_c());
        }
        return i;
    };
    public static Theme THEME = new Theme(){

        @Override
        public void drawScrollBarBackground(int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(x, y, w, h);
        }

        @Override
        public void drawScrollBar(int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(x, y, w, h);
        }
    };
    private final ConfigGroup group;
    private final ConfigGroup originalGroup;
    private final IConfigCallback callback;
    private final String title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;
    private int groupSize = 0;

    public GuiEditConfig(ConfigGroup g, IConfigCallback c) {
        this.group = g;
        this.originalGroup = this.group.copy();
        this.callback = c;
        IChatComponent title0 = g.getDisplayName().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.configEntryButtons = new ArrayList<Widget>();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (w instanceof ButtonConfigEntry) {
                        ButtonConfigEntry entry = (ButtonConfigEntry)w;
                        if (entry.group.collapsed) continue;
                    }
                    this.add(w);
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                GuiEditConfig.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        ArrayList<ConfigValueInstance> list = new ArrayList<ConfigValueInstance>();
        this.collectAllConfigValues(this.group, list);
        if (!list.isEmpty()) {
            list.sort(COMPARATOR);
            ButtonConfigGroup group = null;
            for (ConfigValueInstance instance : list) {
                if (instance.getExcluded()) continue;
                if (group == null || !group.group.equals(instance.getGroup())) {
                    group = new ButtonConfigGroup(this.configPanel, instance.getGroup());
                    this.configEntryButtons.add(group);
                    ++this.groupSize;
                }
                this.configEntryButtons.add(new ButtonConfigEntry(this.configPanel, group, instance));
            }
            if (this.groupSize == 1) {
                this.configEntryButtons.remove(group);
            }
        }
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, StatCollector.func_74838_a((String)"gui.close"), GuiIcons.ACCEPT, (widget, button) -> {
            this.shouldClose = 1;
            widget.getGui().closeGui();
        });
        this.buttonCancel = new SimpleButton(this, StatCollector.func_74838_a((String)"gui.cancel"), GuiIcons.CANCEL, (widget, button) -> {
            this.shouldClose = 2;
            widget.getGui().closeGui();
        });
        this.buttonExpandAll = new SimpleButton(this, StatCollector.func_74838_a((String)"gui.expand_all"), GuiIcons.ADD, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ButtonConfigGroup configGroup = (ButtonConfigGroup)w;
                configGroup.setCollapsed(false);
            }
            this.scroll.setValue(0);
            widget.getGui().refreshWidgets();
        });
        this.buttonCollapseAll = new SimpleButton(this, StatCollector.func_74838_a((String)"gui.collapse_all"), GuiIcons.REMOVE, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ButtonConfigGroup configGroup = (ButtonConfigGroup)w;
                configGroup.setCollapsed(true);
            }
            this.scroll.setValue(0);
            widget.getGui().refreshWidgets();
        });
    }

    private void collectAllConfigValues(ConfigGroup group, List<ConfigValueInstance> list) {
        for (ConfigValueInstance instance : group.getValues()) {
            if (instance.getHidden()) continue;
            list.add(instance);
        }
        for (ConfigGroup group1 : group.getGroups()) {
            this.collectAllConfigValues(group1, list);
        }
    }

    @Override
    public boolean onInit() {
        for (Widget widget : this.configEntryButtons) {
            if (!(widget instanceof ButtonConfigEntry)) continue;
            ButtonConfigEntry entry = (ButtonConfigEntry)widget;
            entry.valueString = null;
        }
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        if (this.groupSize > 1) {
            this.add(this.buttonExpandAll);
            this.add(this.buttonCollapseAll);
        }
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        if (this.groupSize > 1) {
            this.buttonExpandAll.setPos(this.width - 58, 2);
            this.buttonCollapseAll.setPos(this.width - 78, 2);
        }
    }

    @Override
    public void onClosed() {
        super.onClosed();
        if (this.shouldClose != 1) {
            this.group.deserializeNBT(this.originalGroup.serializeNBT());
        }
        this.callback.onConfigSaved(this.group, (ICommandSender)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.shouldClose = 1;
            this.closeGui();
        }
        return false;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(0, 0, w, 20);
        theme.drawString(this.getTitle(), 6, 6, 2);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return THEME;
    }

    public static class ButtonConfigGroup
    extends Button {
        public final ConfigGroup group;
        public String title;
        public String info;
        public boolean collapsed = false;

        public ButtonConfigGroup(Panel panel, ConfigGroup g) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            if (this.group.parent != null) {
                ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
                g = this.group;
                do {
                    groups.add(g);
                } while ((g = g.parent) != null);
                groups.remove(groups.size() - 1);
                StringBuilder builder = new StringBuilder();
                for (int i = groups.size() - 1; i >= 0; --i) {
                    builder.append(((ConfigGroup)groups.get(i)).getDisplayName().func_150254_d());
                    if (i == 0) continue;
                    builder.append(" > ");
                }
                this.title = builder.toString();
            } else {
                this.title = StatCollector.func_74838_a((String)"stat.generalButton");
            }
            String infoKey = this.group.getPath() + ".info";
            this.info = StatCollector.func_94522_b((String)infoKey) ? StatCollector.func_74838_a((String)infoKey) : "";
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((this.collapsed ? EnumChatFormatting.RED + "[-] " : EnumChatFormatting.GREEN + "[v] ") + EnumChatFormatting.RESET + this.title);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(x, y, w, h);
            theme.drawString(this.getTitle(), x + 2, y + 2);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.info.isEmpty()) {
                list.add(this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }

    private class ButtonConfigEntry
    extends Button {
        public final ButtonConfigGroup group;
        public final ConfigValueInstance inst;
        public String keyText;
        private String valueString;

        public ButtonConfigEntry(Panel panel, ButtonConfigGroup g, ConfigValueInstance i) {
            super(panel);
            this.valueString = null;
            this.setHeight(12);
            this.group = g;
            this.inst = i;
            if (!this.inst.getCanEdit()) {
                IChatComponent c = this.inst.getDisplayName().func_150259_f();
                c.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                this.keyText = c.func_150254_d();
            } else {
                this.keyText = this.inst.getDisplayName().func_150254_d();
            }
        }

        public String getValueString() {
            if (this.valueString == null) {
                this.valueString = this.inst.getValue().getStringForGUI().func_150254_d();
            }
            return this.valueString;
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            theme.drawString(this.keyText, x + 4, y + 2, Bits.setFlag(0, 2, mouseOver));
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            String s = this.getValueString();
            int slen = theme.getStringWidth(s);
            if (slen > 150) {
                s = theme.trimStringToWidth(s, 150) + "...";
                slen = 152;
            }
            MutableColor4I textCol = this.inst.getValue().getColor().mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > x + w - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(x + w - slen - 8, y, slen + 8, h);
                }
            }
            theme.drawString(s, this.getGui().width - (slen + 20), y + 2, textCol, 0);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20) {
                GuiHelper.playClickSound();
                this.inst.getValue().onClicked(GuiEditConfig.this, this.inst, button, () -> {
                    this.valueString = null;
                });
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (this.getMouseY() > 18) {
                ChatComponentTranslation component;
                list.add(EnumChatFormatting.UNDERLINE + this.keyText);
                IChatComponent infoText = this.inst.getInfo();
                EnumChatFormatting color = EnumChatFormatting.GRAY;
                if (!this.inst.getCanEdit()) {
                    infoText = new ChatComponentText(ClientUtils.getDisabledTip());
                    color = EnumChatFormatting.RED;
                }
                if (!(infoText instanceof ChatComponentTranslation) || StatCollector.func_94522_b((String)(component = (ChatComponentTranslation)infoText).func_150268_i())) {
                    for (String s : infoText.func_150254_d().split("\\\n")) {
                        list.add(color.toString() + EnumChatFormatting.ITALIC + s);
                    }
                }
                list.add("");
                this.inst.getValue().addInfo(this.inst, list);
            }
        }
    }
}

