/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora.mc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import serverutils.aurora.AuroraConfig;
import serverutils.aurora.PageType;
import serverutils.aurora.page.JsonWebPage;

public class PlayerListJson
extends JsonWebPage {
    private final MinecraftServer server;

    public PlayerListJson(MinecraftServer s) {
        this.server = s;
    }

    @Override
    public PageType getPageType() {
        PageType pageType;
        switch (AuroraConfig.general.player_list_json) {
            case "DISABLED": {
                pageType = PageType.DISABLED;
                break;
            }
            case "REQUIRES_AUTH": {
                pageType = PageType.REQUIRES_AUTH;
                break;
            }
            default: {
                pageType = PageType.ENABLED;
            }
        }
        return pageType;
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("max_players", (Number)this.server.func_71275_y());
        JsonArray players = new JsonArray();
        for (EntityPlayerMP player : this.server.func_71203_ab().field_72404_b) {
            JsonObject o = new JsonObject();
            o.addProperty("name", player.getDisplayName());
            o.addProperty("uuid", player.func_110124_au().toString());
            players.add((JsonElement)o);
        }
        json.add("players", (JsonElement)players);
        return json;
    }
}

