/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.aurora.Aurora;
import serverutils.aurora.AuroraConfig;
import serverutils.command.CmdAddFakePlayer;
import serverutils.command.CmdMySettings;
import serverutils.command.CmdReload;
import serverutils.command.ServerUtilitiesCommands;
import serverutils.command.team.CmdTeam;
import serverutils.lib.ATHelper;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.Universe;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.SidedUtils;
import serverutils.ranks.CommandOverride;
import serverutils.ranks.Ranks;

@Mod(modid="serverutilities", name="Server Utilities", version="2.0.34", dependencies="after:visualprospecting;", guiFactory="serverutils.client.gui.GuiFactory")
public class ServerUtilities {
    public static final String MOD_ID = "serverutilities";
    public static final String MOD_NAME = "Server Utilities";
    public static final String VERSION = "2.0.34";
    public static final Logger LOGGER = LogManager.getLogger((String)"Server Utilities");
    public static final String SERVER_FOLDER = "serverutilities/server/";
    @Mod.Instance(value="serverutilities")
    public static ServerUtilities INST;
    @SidedProxy(serverSide="serverutils.ServerUtilitiesCommon", clientSide="serverutils.client.ServerUtilitiesClient")
    public static ServerUtilitiesCommon PROXY;

    public static IChatComponent lang(@Nullable ICommandSender sender, String key, Object ... args) {
        return SidedUtils.lang(sender, MOD_ID, key, args);
    }

    public static CommandException error(@Nullable ICommandSender sender, String key, Object ... args) {
        return CommandUtils.error(ServerUtilities.lang(sender, key, args));
    }

    public static CommandException errorFeatureDisabledServer(@Nullable ICommandSender sender) {
        return ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Locale.setDefault(Locale.US);
        PROXY.preInit(event);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        Universe.onServerAboutToStart(event);
        MinecraftForge.EVENT_BUS.register((Object)Universe.get());
        FMLCommonHandler.instance().bus().register((Object)Universe.get());
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ServerUtilitiesCommands.registerCommands(event);
        event.registerServerCommand((ICommand)new CmdReload());
        event.registerServerCommand((ICommand)new CmdMySettings());
        event.registerServerCommand((ICommand)new CmdTeam());
        if (ServerUtilitiesConfig.debugging.special_commands) {
            event.registerServerCommand((ICommand)new CmdAddFakePlayer());
        }
        if (AuroraConfig.general.enable) {
            Aurora.start(event.getServer());
        }
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            PROXY.imc(message);
        }
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        Universe.onServerStarted(event);
        if (Ranks.isActive()) {
            boolean bukkitLoaded;
            Ranks.INSTANCE.commands.clear();
            boolean bl = bukkitLoaded = CommonUtils.getClassExists("thermos.ThermosRemapper") || CommonUtils.getClassExists("org.ultramine.server.UltraminePlugin") || CommonUtils.getClassExists("org.bukkit.World");
            if (bukkitLoaded) {
                LOGGER.warn("Thermos/Ultramine detected, command overriding has been disabled. If there are any issues with Server Utilities ranks or permissions, please test them without those mods!");
            }
            if (!ServerUtilitiesConfig.ranks.override_commands || bukkitLoaded) {
                return;
            }
            ServerCommandManager manager = (ServerCommandManager)Ranks.INSTANCE.universe.server.func_71187_D();
            ArrayList<ICommand> commands = new ArrayList<ICommand>(ATHelper.getCommandSet((CommandHandler)manager));
            ATHelper.getCommandSet((CommandHandler)manager).clear();
            manager.func_71555_a().clear();
            Iterator iterator = commands.iterator();
            while (iterator.hasNext()) {
                ICommand command;
                ModContainer container = CommonUtils.getModContainerForClass((command = (ICommand)iterator.next()).getClass());
                manager.func_71560_a(CommandOverride.create(command, container == null ? "command" : "command." + container.getModId(), container));
            }
            ArrayList<CommandOverride> ocommands = new ArrayList<CommandOverride>(Ranks.INSTANCE.commands.values());
            ocommands.sort((o1, o2) -> {
                int i = Boolean.compare(o1.modContainer != null, o2.modContainer != null);
                return i == 0 ? o1.node.compareTo(o2.node) : i;
            });
            for (CommandOverride c : ocommands) {
                Ranks.INSTANCE.commands.put(c.node, c);
            }
            LOGGER.info("Overridden " + manager.func_71555_a().size() + " commands");
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        Universe.onServerStopping(event);
        Aurora.stop();
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> map, Side side) {
        return side != Side.CLIENT || map.containsKey(MOD_ID) && map.get(MOD_ID).equals(VERSION);
    }
}

