/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.IGoggles;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.tiles.IAspectContainerLarge;

public class AutomagyRenderEventHandler {
    public static float tagscale = 0.0f;
    public static boolean isRenderingAspects = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockHighlight(DrawBlockHighlightEvent event) {
        TileEntity te;
        MovingObjectPosition target = event.target;
        if (this.shouldShowAspectsToPlayer(event.player) && (te = event.player.field_70170_p.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d)) != null && te instanceof IAspectContainerLarge && ((IAspectContainerLarge)te).getAspectsReal() != null && ((IAspectContainerLarge)te).getAspectsReal().size() > 0) {
            boolean spaceAbove = event.player.field_70170_p.func_147437_c(target.field_72311_b, target.field_72312_c + 1, target.field_72309_d);
            float shift = ((IAspectContainerLarge)te).getAspectVerticalShift(spaceAbove);
            if (tagscale < 0.3f) {
                tagscale += 0.031f - tagscale / 10.0f;
            }
            this.drawTagsOnContainer(target.field_72311_b, (float)target.field_72312_c + shift, target.field_72309_d, ((IAspectContainerLarge)te).getAspectsReal(), 220, spaceAbove ? ForgeDirection.UP : ForgeDirection.getOrientation((int)event.target.field_72310_e), event.partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        if (tagscale > 0.0f) {
            tagscale -= 0.005f;
        }
        if (isRenderingAspects) {
            isRenderingAspects = false;
        }
    }

    public boolean shouldShowAspectsToPlayer(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70440_f(3);
        if (stack != null && stack.func_77973_b() instanceof IGoggles) {
            return ((IGoggles)stack.func_77973_b()).showIngamePopups(stack, (EntityLivingBase)player);
        }
        return false;
    }

    public void drawTagsOnContainer(double x, double y, double z, AspectList tags, int bright, ForgeDirection dir, float partialTicks) {
        isRenderingAspects = true;
        if (Minecraft.func_71410_x().field_71451_h instanceof EntityPlayer && tags != null && tags.size() > 0) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71451_h;
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            boolean e = false;
            int rowsize = Math.min((int)Math.ceil((double)tags.size() / 5.0), 11);
            if (rowsize < 5) {
                rowsize = 5;
            }
            int current = 0;
            float shifty = 0.0f;
            int left = tags.size();
            for (Aspect tag : tags.getAspects()) {
                int div = Math.min(left, rowsize);
                if (current >= rowsize) {
                    current = 0;
                    shifty -= tagscale * 1.05f;
                    if ((left -= rowsize) < rowsize) {
                        div = left % rowsize;
                    }
                }
                float shift = ((float)current - (float)div / 2.0f + 0.5f) * tagscale * 4.0f;
                shift *= tagscale;
                Color color = new Color(tag.getColor());
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)(-iPX + x + 0.5 + (double)(tagscale * 2.0f * (float)dir.offsetX)), (double)(-iPY + y - (double)shifty + 0.5 + (double)(tagscale * 2.0f * (float)dir.offsetY)), (double)(-iPZ + z + 0.5 + (double)(tagscale * 2.0f * (float)dir.offsetZ)));
                float xd = (float)(iPX - (x + 0.5));
                float zd = (float)(iPZ - (z + 0.5));
                float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
                GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)shift, (double)0.0, (double)0.0);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)tagscale, (float)tagscale, (float)tagscale);
                if (!Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.func_70005_c_(), tag)) {
                    UtilsFX.renderQuadCenteredFromTexture((String)"textures/aspects/_unknown.png", (float)1.0f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (int)bright, (int)771, (float)0.75f);
                    color = new Color(0xAAAAAA);
                } else {
                    UtilsFX.renderQuadCenteredFromTexture((ResourceLocation)tag.getImage(), (float)1.0f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (int)bright, (int)771, (float)0.75f);
                }
                if (tags.getAmount(tag) >= 0) {
                    String am = "" + tags.getAmount(tag);
                    GL11.glScalef((float)0.04f, (float)0.04f, (float)0.04f);
                    GL11.glTranslated((double)0.0, (double)6.0, (double)-0.1);
                    int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(am);
                    GL11.glEnable((int)3042);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 14 - sw, 1, 0x111111);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 13 - sw, 0, 0xFFFFFF);
                }
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
                ++current;
            }
        }
    }
}

