/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.llamalad7.mixinextras.sugar.Local;
import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.storage.RegionFile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RegionFile.class})
public abstract class MixinRegionFile {
    @Unique
    private static final int SECTOR_LENGTH = 4096;
    @Unique
    private static final long SECTOR_LLENGTH = 4096L;
    @Unique
    private static final int SECTOR_MASK = 4095;
    @Shadow
    @Final
    private static byte[] field_76720_a;
    @Shadow
    private RandomAccessFile field_76719_c;
    @Shadow
    @Final
    private int[] field_76716_d;
    @Shadow
    @Final
    private int[] field_76717_e;
    @Shadow
    private ArrayList<Boolean> field_76714_f;
    @Shadow
    private int field_76715_g;
    @Shadow
    private long field_76721_h;
    @Unique
    private final IOException hodgepodge$magicException = new IOException("cancel the constructor");

    @Shadow
    protected abstract int func_76707_e(int var1, int var2);

    @Shadow
    public abstract boolean func_76709_c(int var1, int var2);

    @Shadow
    protected abstract void func_76713_b(int var1, int var2, int var3) throws IOException;

    @Shadow
    protected abstract void func_76711_a(int var1, int var2, int var3) throws IOException;

    @Shadow
    protected abstract void func_76712_a(int var1, byte[] var2, int var3) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/io/File;exists()Z", ordinal=0)})
    private void hodgepodge$initRedirect(File fileName, CallbackInfo ci) throws IOException {
        this.field_76715_g = 0;
        try {
            int i;
            if (fileName.exists()) {
                this.field_76721_h = fileName.lastModified();
            }
            this.field_76719_c = new RandomAccessFile(fileName, "rw");
            if (this.field_76719_c.length() < 4096L) {
                this.field_76719_c.write(field_76720_a);
                this.field_76719_c.write(field_76720_a);
                this.field_76715_g += 8192;
            }
            if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
                int oversize = (int)(this.field_76719_c.length() & 0xFFFL);
                int missing = 4096 - oversize;
                this.field_76719_c.write(field_76720_a, 0, missing);
            }
            int numSectors = (int)(this.field_76719_c.length() / 4096L);
            this.field_76714_f = new ArrayList(numSectors);
            for (i = 0; i < numSectors; ++i) {
                this.field_76714_f.add(true);
            }
            this.field_76714_f.set(0, false);
            this.field_76714_f.set(1, false);
            this.field_76719_c.seek(0L);
            for (i = 0; i < 1024; ++i) {
                int offset;
                this.field_76716_d[i] = offset = this.field_76719_c.readInt();
                int length = offset & 0xFF;
                if (length == 255 && offset >> 8 <= this.field_76714_f.size()) {
                    this.field_76719_c.seek((long)(offset >> 8) * 4096L);
                    length = (this.field_76719_c.readInt() + 4) / 4096 + 1;
                    this.field_76719_c.seek(i * 4 + 4);
                }
                if (offset != 0 && (offset >> 8) + length <= this.field_76714_f.size()) {
                    for (int l = 0; l < length; ++l) {
                        this.field_76714_f.set((offset >> 8) + l, false);
                    }
                    continue;
                }
                if (length <= 0) continue;
                FMLLog.warning((String)"Invalid chunk: (%s, %s) Offset: %s Length: %s runs off end file. %s", (Object[])new Object[]{i % 32, i / 32, offset >> 8, length, fileName});
            }
            for (i = 0; i < 1024; ++i) {
                int timestamp;
                this.field_76717_e[i] = timestamp = this.field_76719_c.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        throw this.hodgepodge$magicException;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/io/IOException;printStackTrace()V"))
    private void hodgepodge$ignoreMagicException(IOException e) {
        if (e != this.hodgepodge$magicException) {
            e.printStackTrace(System.err);
        }
    }

    @Overwrite(remap=false)
    public synchronized boolean chunkExists(int x, int z) {
        return this.func_76709_c(x, z);
    }

    @ModifyVariable(method={"Lnet/minecraft/world/chunk/storage/RegionFile;getChunkDataInputStream(II)Ljava/io/DataInputStream;"}, at=@At(value="STORE"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/RegionFile;getOffset(II)I"), to=@At(value="INVOKE", target="Ljava/util/ArrayList;size()I")), index=5)
    private int hodgepodge$getChunkDataInputStream$extendedSectorCount(int sectorCount, @Local(index=4) int sector) throws IOException {
        if (sectorCount == 255) {
            this.field_76719_c.seek((long)sector * 4096L);
            sectorCount = (this.field_76719_c.readInt() + 4) / 4096 + 1;
        }
        return sectorCount;
    }

    @ModifyArg(method={"getChunkDataInputStream"}, at=@At(value="INVOKE", target="Ljava/io/DataInputStream;<init>(Ljava/io/InputStream;)V"), expect=2)
    private InputStream hodgepodge$getChunkDataInputStream$buffer(InputStream is) {
        return new BufferedInputStream(is);
    }

    @ModifyArg(method={"getChunkDataOutputStream"}, at=@At(value="INVOKE", target="Ljava/io/DataOutputStream;<init>(Ljava/io/OutputStream;)V"), index=0)
    private OutputStream hodgepodge$getChunkDataOutputStream$buffer(OutputStream os) {
        return new BufferedOutputStream(os);
    }

    @Overwrite
    protected synchronized void func_76706_a(int x, int z, byte[] data, int length) {
        try {
            int sectorsNeeded;
            int offset = this.func_76707_e(x, z);
            int sector = offset >> 8;
            int sectorCount = offset & 0xFF;
            if (sectorCount == 255) {
                this.field_76719_c.seek((long)sector * 4096L);
                sectorCount = (this.field_76719_c.readInt() + 4) / 4096 + 1;
            }
            if ((sectorsNeeded = (length + 5) / 4096 + 1) >= 256) {
                Common.log.warn("[Hodgepodge] Oversized Chunk at ({}, {}) - {} bytes used", new Object[]{x, z, (long)sectorsNeeded * 4096L});
            }
            if (sector != 0 && sectorCount == sectorsNeeded) {
                this.func_76712_a(sector, data, length);
            } else {
                int i;
                for (int i2 = 0; i2 < sectorCount; ++i2) {
                    this.field_76714_f.set(sector + i2, true);
                }
                int sectorStart = this.field_76714_f.indexOf(true);
                int sectorLength = 0;
                if (sectorStart != -1) {
                    for (i = sectorStart; i < this.field_76714_f.size(); ++i) {
                        if (sectorLength != 0) {
                            sectorLength = this.field_76714_f.get(i).booleanValue() ? ++sectorLength : 0;
                        } else if (this.field_76714_f.get(i).booleanValue()) {
                            sectorStart = i;
                            sectorLength = 1;
                        }
                        if (sectorLength >= sectorsNeeded) break;
                    }
                }
                if (sectorLength >= sectorsNeeded) {
                    sector = sectorStart;
                    this.func_76711_a(x, z, sector << 8 | Math.min(sectorsNeeded, 255));
                    for (i = 0; i < sectorsNeeded; ++i) {
                        this.field_76714_f.set(sector + i, false);
                    }
                    this.func_76712_a(sector, data, length);
                } else {
                    this.field_76719_c.seek(this.field_76719_c.length());
                    sector = this.field_76714_f.size();
                    for (i = 0; i < sectorsNeeded; ++i) {
                        this.field_76719_c.write(field_76720_a);
                        this.field_76714_f.add(false);
                    }
                    this.field_76715_g += 4096 * sectorsNeeded;
                    this.func_76712_a(sector, data, length);
                    this.func_76711_a(x, z, sector << 8 | Math.min(sectorsNeeded, 255));
                }
            }
            this.func_76713_b(x, z, (int)(MinecraftServer.func_130071_aq() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace(System.err);
        }
    }
}

