/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_BaseModule;
import com.github.technus.tectech.util.CommonValues;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_EM_SmeltingModule
extends GT_MetaTileEntity_EM_BaseModule {
    private long EUt = 0L;
    private long currentParallel = 0L;
    private boolean furnaceMode = false;
    long wirelessEUt = 0L;

    public GT_MetaTileEntity_EM_SmeltingModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_SmeltingModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_SmeltingModule(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.blastFurnaceRecipes, RecipeMaps.furnaceRecipes);
    }

    private static RecipeMap<?> getRecipeMap(boolean furnaceMode) {
        if (furnaceMode) {
            return RecipeMaps.furnaceRecipes;
        }
        return RecipeMaps.blastFurnaceRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Nonnull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                RecipeMap recipes = GT_MetaTileEntity_EM_SmeltingModule.getRecipeMap(GT_MetaTileEntity_EM_SmeltingModule.this.furnaceMode);
                return super.findRecipeMatches(recipes);
            }

            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                if (recipe.mSpecialValue > GT_MetaTileEntity_EM_SmeltingModule.this.getHeat()) {
                    return CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
                }
                GT_MetaTileEntity_EM_SmeltingModule.this.wirelessEUt = (long)recipe.mEUt * (long)GT_MetaTileEntity_EM_SmeltingModule.this.getMaxParallel().intValue();
                if (WirelessNetworkManager.getUserEU((UUID)GT_MetaTileEntity_EM_SmeltingModule.this.userUUID).compareTo(BigInteger.valueOf(GT_MetaTileEntity_EM_SmeltingModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower((long)(GT_MetaTileEntity_EM_SmeltingModule.this.wirelessEUt * (long)recipe.mDuration));
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GT_Recipe recipe) {
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)GT_MetaTileEntity_EM_SmeltingModule.this.userUUID, (long)(-this.calculatedEut * (long)this.duration))) {
                    return CheckRecipeResultRegistry.insufficientPower((long)(this.calculatedEut * (long)this.duration));
                }
                GT_MetaTileEntity_EM_SmeltingModule.this.currentParallel = this.calculatedParallels;
                GT_MetaTileEntity_EM_SmeltingModule.this.EUt = this.calculatedEut;
                this.setCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(TierEU.MAX).setRecipeHeat(recipe.mSpecialValue).setHeatOC(true).setHeatDiscount(true).setMachineHeat(GT_MetaTileEntity_EM_SmeltingModule.this.getHeat().intValue());
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setMaxParallel(this.getMaxParallel().intValue());
        logic.setSpeedBonus(this.getSpeedBonus().floatValue());
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.furnaceSwitch((IWidgetBuilder<?>)builder));
    }

    protected ButtonWidget furnaceSwitch(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            this.furnaceMode = !this.furnaceMode;
        }).setPlayClickSound(this.isFurnaceModeOn()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isFurnaceModeOn()) {
                ret.add(GT_UITextures.BUTTON_STANDARD_PRESSED);
                ret.add(GT_UITextures.OVERLAY_BUTTON_CHECKMARK);
            } else {
                ret.add(GT_UITextures.BUTTON_STANDARD);
                ret.add(GT_UITextures.OVERLAY_BUTTON_CROSS);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isFurnaceModeOn, this::setFurnaceMode), builder).addTooltip(StatCollector.func_74838_a((String)"fog.button.furnacemode.tooltip")).setTooltipShowUpDelay(5).setPos(174, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    private boolean isFurnaceModeOn() {
        return this.furnaceMode;
    }

    private void setFurnaceMode(boolean enabled) {
        this.furnaceMode = enabled;
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74757_a("furnaceMode", this.furnaceMode);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.furnaceMode = NBT2.func_74767_n("furnaceMode");
        super.loadNBTData(NBT2);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.EUt) + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.getMaxParallel().intValue()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.currentParallel));
        str.add(EnumChatFormatting.YELLOW + "Heat Capacity: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.getHeat().intValue()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time multiplier: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((double)this.getSpeedBonus().floatValue()));
        return str.toArray(new String[0]);
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Smelting Module").addInfo("Controller block of the Smelting Module").addInfo("Uses a Star to Smelt Metals").addSeparator().beginStructureBlock(1, 4, 2, false).addEnergyHatch("Any Infinite Spacetime Casing", new int[]{1}).addMaintenanceHatch("Any Infinite Spacetime Casing", new int[]{1}).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }
}

