/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_BaseModule;
import com.github.technus.tectech.util.CommonValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_EM_MoltenModule
extends GT_MetaTileEntity_EM_BaseModule {
    private long EUt = 0L;
    private int currentParallel = 0;
    long wirelessEUt = 0L;

    public GT_MetaTileEntity_EM_MoltenModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_MoltenModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_MoltenModule(this.mName);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            private FluidStack[] meltableItems;

            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                if (recipe.mSpecialValue > GT_MetaTileEntity_EM_MoltenModule.this.getHeat()) {
                    return CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
                }
                GT_MetaTileEntity_EM_MoltenModule.this.wirelessEUt = (long)recipe.mEUt * (long)GT_MetaTileEntity_EM_MoltenModule.this.getMaxParallel().intValue();
                if (WirelessNetworkManager.getUserEU((UUID)GT_MetaTileEntity_EM_MoltenModule.this.userUUID).compareTo(BigInteger.valueOf(GT_MetaTileEntity_EM_MoltenModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower((long)(GT_MetaTileEntity_EM_MoltenModule.this.wirelessEUt * (long)recipe.mDuration));
                }
                this.meltableItems = new FluidStack[recipe.mOutputs.length];
                for (int i = 0; i < recipe.mOutputs.length; ++i) {
                    Materials mat;
                    ItemStack item = recipe.getOutput(i);
                    if (item == null) continue;
                    ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)item);
                    Materials materials = mat = data == null ? null : data.mMaterial.mMaterial;
                    if (mat != null) {
                        if (mat.mStandardMoltenFluid != null) {
                            this.meltableItems[i] = mat.getMolten(144L);
                            continue;
                        }
                        if (mat.mFluid == null) continue;
                        this.meltableItems[i] = mat.getFluid(1000L);
                        continue;
                    }
                    String dict = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)item)[0]);
                    String strippedOreDict = dict.substring(8);
                    this.meltableItems[i] = FluidRegistry.getFluidStack((String)("molten." + strippedOreDict.toLowerCase()), (int)144);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(TierEU.MAX).setRecipeHeat(recipe.mSpecialValue).setHeatOC(true).setHeatDiscount(true).setMachineHeat(GT_MetaTileEntity_EM_MoltenModule.this.getHeat().intValue());
            }

            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GT_Recipe recipe) {
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)GT_MetaTileEntity_EM_MoltenModule.this.userUUID, (long)(-this.calculatedEut * (long)this.duration))) {
                    return CheckRecipeResultRegistry.insufficientPower((long)(this.calculatedEut * (long)this.duration));
                }
                GT_MetaTileEntity_EM_MoltenModule.this.currentParallel = this.calculatedParallels;
                GT_MetaTileEntity_EM_MoltenModule.this.EUt = this.calculatedEut;
                this.setCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setCustomItemOutputCalculation(currentParallel -> {
                    ArrayList outputItems = new ArrayList();
                    for (int i = 0; i < recipe.mOutputs.length; ++i) {
                        ItemStack item = recipe.getOutput(i);
                        if (item == null || this.meltableItems[i] != null) continue;
                        ItemStack itemToAdd = item.func_77946_l();
                        GT_ParallelHelper.addItemsLong(outputItems, (ItemStack)itemToAdd, (long)((long)item.field_77994_a * (long)currentParallel.intValue()));
                    }
                    return outputItems.toArray(new ItemStack[0]);
                }).setCustomFluidOutputCalculation(currentParallel -> {
                    FluidStack fluidToAdd;
                    FluidStack fluid;
                    int i;
                    ArrayList fluids = new ArrayList();
                    for (i = 0; i < recipe.mOutputs.length; ++i) {
                        fluid = this.meltableItems[i];
                        if (fluid == null) continue;
                        fluidToAdd = fluid.copy();
                        long fluidAmount = (long)fluidToAdd.amount * (long)recipe.mOutputs[i].field_77994_a * (long)currentParallel.intValue();
                        GT_ParallelHelper.addFluidsLong(fluids, (FluidStack)fluidToAdd, (long)fluidAmount);
                    }
                    for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                        fluid = recipe.getFluidOutput(i);
                        if (fluid == null) continue;
                        fluidToAdd = fluid.copy();
                        GT_ParallelHelper.addFluidsLong(fluids, (FluidStack)fluidToAdd, (long)((long)fluidToAdd.amount * (long)currentParallel.intValue()));
                    }
                    return fluids.toArray(new FluidStack[0]);
                });
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setMaxParallel(this.getMaxParallel().intValue());
        logic.setSpeedBonus(this.getSpeedBonus().floatValue());
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024)};
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.EUt) + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.getMaxParallel().intValue()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.currentParallel));
        str.add(EnumChatFormatting.YELLOW + "Heat Capacity: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.getHeat().intValue()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time multiplier: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((double)this.getSpeedBonus().floatValue()));
        return str.toArray(new String[0]);
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Molten Module").addInfo("Controller block of the Molten Module").addInfo("Uses a Star to to melt Metals").addSeparator().beginStructureBlock(1, 4, 2, false).addEnergyHatch("Any Infinite Spacetime Casing", new int[]{1}).addMaintenanceHatch("Any Infinite Spacetime Casing", new int[]{1}).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }
}

