/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import com.github.technus.tectech.thing.gui.TecTechUITextures;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ResearchStationFrontend
extends RecipeMapFrontend {
    public ResearchStationFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return Collections.singletonList(new Pos2d(52, 33));
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return Collections.singletonList(new Pos2d(106, 33));
    }

    public Pos2d getSpecialItemPosition() {
        return new Pos2d(124, 62);
    }

    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        long eut = recipeInfo.recipe.mEUt;
        int computation = recipeInfo.recipe.mDuration;
        short ampere = (short)(recipeInfo.recipe.mSpecialValue & 0xFFFF);
        short minComputationPerSec = (short)(recipeInfo.recipe.mSpecialValue >>> 16);
        recipeInfo.drawText(StatCollector.func_74837_a((String)"tt.nei.research.max_eu", (Object[])new Object[]{GT_Utility.formatNumbers((long)((long)(1 + (computation - minComputationPerSec) / minComputationPerSec) * eut * (long)ampere * 20L))}));
        recipeInfo.drawText(GT_Utility.trans((String)"153", (String)"Usage: ") + GT_Utility.formatNumbers((long)(eut * (long)ampere)) + " EU/t");
        recipeInfo.drawText(GT_Utility.trans((String)"154", (String)"Voltage: ") + GT_Utility.formatNumbers((long)eut) + " EU/t");
        recipeInfo.drawText(GT_Utility.trans((String)"155", (String)"Amperage: ") + GT_Utility.formatNumbers((long)ampere));
        recipeInfo.drawText(StatCollector.func_74837_a((String)"tt.nei.research.computation", (Object[])new Object[]{GT_Utility.formatNumbers((long)computation)}));
        recipeInfo.drawText(StatCollector.func_74837_a((String)"tt.nei.research.min_computation", (Object[])new Object[]{GT_Utility.formatNumbers((long)minComputationPerSec)}));
    }

    protected void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
    }

    public void addProgressBar(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        int bar1Width = 25;
        int bar2Width = 11;
        int bar3Height = 18;
        List splitProgress = ResearchStationFrontend.splitProgress(progressSupplier, (int[])new int[]{bar1Width, bar2Width, bar3Height});
        builder.widget(new ProgressBar().setTexture(TecTechUITextures.PROGRESSBAR_RESEARCH_STATION_1, bar1Width).setDirection(ProgressBar.Direction.RIGHT).setProgress((Supplier)splitProgress.get(0)).setSynced(false, false).setPos(new Pos2d(81, 40).add(windowOffset)).setSize(bar1Width, 5));
        builder.widget(new ProgressBar().setTexture(TecTechUITextures.PROGRESSBAR_RESEARCH_STATION_2, bar2Width).setDirection(ProgressBar.Direction.RIGHT).setProgress((Supplier)splitProgress.get(1)).setSynced(false, false).setPos(new Pos2d(124, 40).add(windowOffset)).setSize(bar2Width, 5));
        builder.widget(new ProgressBar().setTexture(TecTechUITextures.PROGRESSBAR_RESEARCH_STATION_3, bar3Height).setDirection(ProgressBar.Direction.DOWN).setProgress((Supplier)splitProgress.get(2)).setSynced(false, false).setPos(new Pos2d(128, 44).add(windowOffset)).setSize(10, bar3Height));
    }
}

