/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.spark;

import com.github.technus.tectech.mechanics.spark.ThaumSpark;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import gregtech.api.enums.Mods;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import thaumcraft.client.fx.bolt.FXLightningBolt;

public class RendererMessage
implements IMessage {
    HashSet<ThaumSpark> sparkList;

    public void fromBytes(ByteBuf pBuffer) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        try {
            byte[] boop = pBuffer.array();
            boop = Arrays.copyOfRange(boop, 1, boop.length);
            ByteArrayInputStream is = new ByteArrayInputStream(boop);
            ValidatingObjectInputStream ois = new ValidatingObjectInputStream(is);
            Object data = ois.readObject();
            this.sparkList = (HashSet)data;
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf pBuffer) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.sparkList);
            oos.flush();
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            pBuffer.writeBytes((InputStream)is, baos.toByteArray().length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void thaumLightning(int tX, int tY, int tZ, int tXN, int tYN, int tZN, int wID) {
        if (Mods.Thaumcraft.isModLoaded()) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world.field_73011_w.field_76574_g == wID) {
                FXLightningBolt bolt = new FXLightningBolt((World)world, (double)((float)tX + 0.5f), (double)((float)tY + 0.5f), (double)((float)tZ + 0.5f), (double)((float)(tX + tXN) + 0.5f), (double)((float)(tY + tYN) + 0.5f), (double)((float)(tZ + tZN) + 0.5f), world.field_73012_v.nextLong(), 6, 0.5f, 8);
                bolt.defaultFractal();
                bolt.setType(2);
                bolt.setWidth(0.125f);
                bolt.finalizeBolt();
            }
        }
    }

    private static class ValidatingObjectInputStream
    extends ObjectInputStream {
        private static final Logger logger = LogManager.getLogger();
        private static final Marker securityMarker = MarkerManager.getMarker((String)"SuspiciousPackets");

        private ValidatingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (!name.equals("java.util.HashSet") && !name.equals("com.github.technus.tectech.mechanics.spark.ThaumSpark")) {
                logger.warn(securityMarker, "Received packet containing disallowed class: " + name);
                throw new RuntimeException();
            }
            return super.resolveClass(desc);
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<RendererData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, RendererData pMessage, MessageContext pCtx) {
            int i;
            Random localRand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
            int[] zapsToUse = new int[4];
            for (i = 0; i < 3; ++i) {
                zapsToUse[i] = localRand.nextInt(pMessage.sparkList.size());
            }
            i = 0;
            for (ThaumSpark sp : pMessage.sparkList) {
                for (int j : zapsToUse) {
                    if (i != j) continue;
                    RendererMessage.thaumLightning(sp.x, sp.y, sp.z, sp.xR, sp.yR, sp.zR, sp.wID);
                }
                ++i;
            }
            pMessage.sparkList.clear();
            return null;
        }
    }

    public static class RendererData
    extends RendererMessage {
        public RendererData() {
        }

        public RendererData(HashSet<ThaumSpark> eSparkList) {
            this.sparkList = eSparkList;
        }
    }
}

