/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit;

import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.service.blockfinder.BlockFindService;
import com.gtnh.findit.service.blockfinder.ClientBlockFindService;
import com.gtnh.findit.service.cooldown.SearchCooldownService;
import com.gtnh.findit.service.itemfinder.ClientItemFindService;
import com.gtnh.findit.service.itemfinder.ItemFindService;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;

@Mod(modid="findit", name="FindIt", version="1.2.5", dependencies="required-after:NotEnoughItems;after:gregtech", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.7.10]")
public class FindIt {
    public static final String MOD_ID = "findit";
    public static final String MOD_NAME = "FindIt";
    public static final String VERSION = "1.2.5";
    @Mod.Instance(value="findit")
    public static FindIt INSTANCE;
    private boolean extraUtilitiesLoaded;
    private boolean gregTechloaded;
    private SearchCooldownService cooldownService;
    private BlockFindService blockFindService;
    private ItemFindService itemFindService;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.extraUtilitiesLoaded = Loader.isModLoaded((String)"ExtraUtilities");
        this.gregTechloaded = Loader.isModLoaded((String)"gregtech");
        FindItConfig.setup(event.getSuggestedConfigurationFile());
        boolean isClient = event.getSide() == Side.CLIENT;
        this.cooldownService = new SearchCooldownService();
        this.blockFindService = isClient ? new ClientBlockFindService() : new BlockFindService();
        this.itemFindService = isClient ? new ClientItemFindService() : new ItemFindService();
    }

    public static SearchCooldownService getCooldownService() {
        return FindIt.INSTANCE.cooldownService;
    }

    public static BlockFindService getBlockFindService() {
        return FindIt.INSTANCE.blockFindService;
    }

    public static ItemFindService getItemFindService() {
        return FindIt.INSTANCE.itemFindService;
    }

    public static boolean isExtraUtilitiesLoaded() {
        return FindIt.INSTANCE.extraUtilitiesLoaded;
    }

    public static boolean isGregTechLoaded() {
        return FindIt.INSTANCE.gregTechloaded;
    }
}

