/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.forestry;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import fox.spiteful.avaritia.compat.forestry.Allele;
import fox.spiteful.avaritia.compat.forestry.Genomes;
import fox.spiteful.avaritia.compat.forestry.GreedyBeeSpecies;
import fox.spiteful.avaritia.compat.forestry.Ranger;
import java.util.ArrayList;
import java.util.Collection;

public class ExpensiveMutation
implements IBeeMutation {
    private IAlleleBeeSpecies mom;
    private IAlleleBeeSpecies dad;
    private IAllele[] template;
    private boolean secret = false;
    private float baseChance;

    public ExpensiveMutation(IAlleleBeeSpecies first, IAlleleBeeSpecies second, IAllele[] result, float chance) {
        this.mom = first;
        this.dad = second;
        this.template = result;
        this.baseChance = chance;
        BeeManager.beeRoot.registerMutation((IMutation)this);
    }

    public static void mutate() {
        IAlleleBeeSpecies first = Ranger.extra ? Allele.getExtraSpecies("Relic") : Allele.getBaseSpecies("Austere");
        IAlleleBeeSpecies second = Allele.getBaseSpecies("Hermitic");
        new ExpensiveMutation(first, second, Genomes.getBalanced(), 0.8f);
        first = Ranger.magic ? Allele.getMagicSpecies("Draconic") : Allele.getBaseSpecies("Heroic");
        new ExpensiveMutation(first, GreedyBeeSpecies.ANNOYING, Genomes.getTedious(), 0.7f);
        first = Ranger.extra ? Allele.getExtraSpecies("Virulent") : (Ranger.magic ? Allele.getMagicSpecies("Withering") : Allele.getBaseSpecies("Demonic"));
        new ExpensiveMutation(first, GreedyBeeSpecies.TEDIOUS, Genomes.getInsufferable(), 0.6f);
        new ExpensiveMutation(Allele.getBaseSpecies("Edenic"), GreedyBeeSpecies.INSUFFERABLE, Genomes.getInfinite(), 0.4f);
        first = Ranger.magic ? Allele.getMagicSpecies("Doctoral") : (Ranger.extra ? Allele.getExtraSpecies("Diamond") : Allele.getBaseSpecies("Phantasmal"));
        new ExpensiveMutation(first, GreedyBeeSpecies.TRIPPY, Genomes.getCosmic(), 0.8f);
        first = Ranger.magic ? Allele.getMagicSpecies("Firey") : (Ranger.extra ? Allele.getExtraSpecies("Volcanic") : Allele.getBaseSpecies("Industrious"));
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public IAlleleSpecies getAllele0() {
        return this.mom;
    }

    public IAlleleSpecies getAllele1() {
        return this.dad;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public float getBaseChance() {
        return this.baseChance;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean isPartner(IAllele allele) {
        return this.mom.getUID().equals(allele.getUID()) || this.dad.getUID().equals(allele.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        if (allele.getUID().equals(this.mom.getUID())) {
            return this.dad;
        }
        return this.mom;
    }

    public Collection<String> getSpecialConditions() {
        return new ArrayList<String>();
    }

    public float getChance(IBeeHousing housing, IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IBeeGenome genome0, IBeeGenome genome1) {
        float finalChance = 0.0f;
        float chance = this.baseChance * 1.0f;
        if (this.isPartner((IAllele)allele0) && this.isPartner((IAllele)allele1)) {
            float housingModifier = 1.0f;
            for (IBeeModifier modifier : housing.getBeeModifiers()) {
                housingModifier *= modifier.getMutationModifier(genome0, genome1, chance);
            }
            finalChance = Math.round(chance * housingModifier * BeeManager.beeRoot.getBeekeepingMode(housing.getWorld()).getBeeModifier().getMutationModifier(genome0, genome1, chance));
        }
        return finalChance;
    }
}

