/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.items.storage.ItemViewCell;
import appeng.util.prioitylist.IPartitionList;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.util.FluidSorters;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidRepo
implements IDisplayRepo {
    protected final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    protected final ArrayList<IAEItemStack> view = new ArrayList();
    protected final ArrayList<ItemStack> dsp = new ArrayList();
    protected final ArrayList<IAEItemStack> cache = new ArrayList();
    protected final IScrollSource src;
    protected final ISortSource sortSrc;
    protected int rowSize = 9;
    protected String searchString = "";
    protected String lastSearchString = "";
    protected IPartitionList<IAEItemStack> myPartitionList;
    private String NEIWord = null;
    private boolean hasPower;

    public FluidRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public ItemStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = (IAEItemStack)this.list.findPrecise((IAEStack)is);
        if (st != null) {
            st.reset();
            st.add(is);
            if (GuiScreen.func_146272_n() && this.view.contains(st)) {
                this.view.get(this.view.indexOf(st)).setStackSize(st.getStackSize());
            }
        } else {
            if (GuiScreen.func_146272_n()) {
                this.cache.add(is);
            }
            this.list.add((IAEStack)is);
        }
    }

    protected boolean needUpdateView() {
        return !GuiScreen.func_146272_n() || !this.lastSearchString.equals(this.searchString);
    }

    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter((ItemStack[])list);
        this.updateView();
    }

    public void updateView() {
        Pattern m;
        if (this.needUpdateView()) {
            this.view.clear();
        }
        this.dsp.clear();
        this.view.ensureCapacity(this.list.size());
        this.dsp.ensureCapacity(this.list.size());
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
            this.updateNEI(this.searchString);
        }
        String innerSearch = this.searchString;
        boolean searchMod = false;
        if (innerSearch.startsWith("@")) {
            searchMod = true;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        Iterator ignore = (this.needUpdateView() ? this.list : this.cache).iterator();
        while (ignore.hasNext()) {
            IAEItemStack is = (IAEItemStack)ignore.next();
            if (this.myPartitionList != null && !this.myPartitionList.isListed((IAEStack)is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L) continue;
            Fluid fluid = ItemFluidDrop.getAeFluidStack(is).getFluid();
            if (FluidCraftAPI.instance().isBlacklistedInDisplay(fluid.getClass())) continue;
            if (searchMod) {
                if (!m.matcher(Util.getFluidModID(fluid).toLowerCase()).find() && !m.matcher(Util.getFluidModName(fluid).toLowerCase()).find()) continue;
                this.view.add(is);
                continue;
            }
            if (!m.matcher(fluid.getLocalizedName().toLowerCase()).find()) continue;
            this.view.add(is);
        }
        if (this.needUpdateView()) {
            Enum SortBy = this.sortSrc.getSortBy();
            Enum SortDir2 = this.sortSrc.getSortDir();
            FluidSorters.setDirection((SortDir)SortDir2);
            FluidSorters.init();
            if (SortBy == SortOrder.MOD) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_MOD);
            } else if (SortBy == SortOrder.AMOUNT) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
            } else if (SortBy == SortOrder.INVTWEAKS) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
            } else {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_NAME);
            }
        } else {
            this.cache.clear();
        }
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
        this.lastSearchString = this.searchString;
    }

    protected void updateNEI(String filter) {
        try {
            if (this.NEIWord == null || !this.NEIWord.equals(filter)) {
                Class c = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
                Field fldSearchField = c.getField("searchField");
                Object searchField = fldSearchField.get(c);
                Method a = searchField.getClass().getMethod("setText", String.class);
                Method b = searchField.getClass().getMethod("onTextChange", String.class);
                this.NEIWord = filter;
                a.invoke(searchField, filter);
                b.invoke(searchField, "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

