/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.api.ModifierLoader;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.config.Configuration;

public class MM_Ender
extends MobModifier {
    private long nextAbilityUse = 0L;
    private static long coolDown;
    private static float reflectMultiplier;
    private static float maxReflectDamage;
    private static String[] suffix;
    private static String[] prefix;

    public MM_Ender(@Nullable MobModifier next) {
        super("Ender", next);
    }

    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage) {
        long time = mob.field_70173_aa;
        if (time > this.nextAbilityUse && source.func_76346_g() != null && source.func_76346_g() != mob && this.teleportToEntity(mob, source.func_76346_g()) && !InfernalMobsCore.instance().isInfiniteLoop(mob, source.func_76346_g())) {
            this.nextAbilityUse = time + coolDown;
            source.func_76346_g().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)mob), Math.min(maxReflectDamage, damage * reflectMultiplier));
            return super.onHurt(mob, source, 0.0f);
        }
        return super.onHurt(mob, source, damage);
    }

    private boolean teleportToEntity(EntityLivingBase mob, Entity par1Entity) {
        Vec3 vector = Vec3.func_72443_a((double)(mob.field_70165_t - par1Entity.field_70165_t), (double)(mob.field_70121_D.field_72338_b + (double)(mob.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)(mob.field_70161_v - par1Entity.field_70161_v));
        vector = vector.func_72432_b();
        double telDist = 16.0;
        double destX = mob.field_70165_t + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0 - vector.field_72450_a * telDist;
        double destY = mob.field_70163_u + (double)(mob.field_70170_p.field_73012_v.nextInt(16) - 8) - vector.field_72448_b * telDist;
        double destZ = mob.field_70161_v + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0 - vector.field_72449_c * telDist;
        return this.teleportTo(mob, destX, destY, destZ);
    }

    private boolean teleportTo(EntityLivingBase mob, double destX, double destY, double destZ) {
        int z;
        int y;
        double oldX = mob.field_70165_t;
        double oldY = mob.field_70163_u;
        double oldZ = mob.field_70161_v;
        boolean success = false;
        mob.field_70165_t = destX;
        mob.field_70163_u = destY;
        mob.field_70161_v = destZ;
        int x = MathHelper.func_76128_c((double)mob.field_70165_t);
        if (mob.field_70170_p.func_72899_e(x, y = MathHelper.func_76128_c((double)mob.field_70163_u), z = MathHelper.func_76128_c((double)mob.field_70161_v))) {
            boolean hitGround = false;
            while (!hitGround && y < 96 && y > 0) {
                Block blockID = mob.field_70170_p.func_147439_a(x, y - 1, z);
                if (blockID.func_149688_o().func_76230_c()) {
                    hitGround = true;
                    continue;
                }
                mob.field_70163_u -= 1.0;
                --y;
            }
            if (hitGround) {
                mob.func_70107_b(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v);
                if (mob.field_70170_p.func_72945_a((Entity)mob, mob.field_70121_D).isEmpty() && !mob.field_70170_p.func_72953_d(mob.field_70121_D) && !mob.field_70170_p.func_72829_c(mob.field_70121_D)) {
                    success = true;
                }
            } else {
                return false;
            }
        }
        if (!success) {
            mob.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        int range = 128;
        for (int i = 0; i < range; ++i) {
            double var19 = (double)i / ((double)range - 1.0);
            float var21 = (mob.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float var22 = (mob.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float var23 = (mob.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double var24 = oldX + (mob.field_70165_t - oldX) * var19 + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)mob.field_70130_N * 2.0;
            double var26 = oldY + (mob.field_70163_u - oldY) * var19 + mob.field_70170_p.field_73012_v.nextDouble() * (double)mob.field_70131_O;
            double var28 = oldZ + (mob.field_70161_v - oldZ) * var19 + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)mob.field_70130_N * 2.0;
            mob.field_70170_p.func_72869_a("portal", var24, var26, var28, (double)var21, (double)var22, (double)var23);
        }
        mob.field_70170_p.func_72908_a(oldX, oldY, oldZ, "mob.endermen.portal", 1.0f, 1.0f);
        mob.field_70170_p.func_72956_a((Entity)mob, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }

    static {
        suffix = new String[]{"theEnderborn", "theTrickster"};
        prefix = new String[]{"enderborn", "tricky"};
    }

    public static class Loader
    extends ModifierLoader<MM_Ender> {
        public Loader() {
            super(MM_Ender.class);
        }

        @Override
        public MM_Ender make(@Nullable MobModifier next) {
            return new MM_Ender(next);
        }

        @Override
        public void loadConfig(Configuration config) {
            coolDown = config.get(this.getModifierClassName(), "coolDownMillis", 15000.0, "Time between ability uses").getInt(15000) / 50;
            reflectMultiplier = (float)config.get(this.getModifierClassName(), "enderReflectMultiplier", 0.75, "When a mob with Ender modifier gets hurt it teleports and reflects some of the damage originally dealt. This sets the multiplier for the reflected damage").getDouble(0.75);
            maxReflectDamage = (float)config.get(this.getModifierClassName(), "enderReflectMaxDamage", 10.0, "When a mob with Ender modifier gets hurt it teleports and reflects some of the damage originally dealt. This sets the maximum amount that can be inflicted (0, or less than zero for unlimited reflect damage)").getDouble(10.0);
        }
    }
}

