/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import pers.gwyog.gtneioreplugin.plugin.gregtech5.PluginGT5Base;
import pers.gwyog.gtneioreplugin.plugin.item.ItemDimensionDisplay;
import pers.gwyog.gtneioreplugin.util.DimensionHelper;
import pers.gwyog.gtneioreplugin.util.GT5OreLayerHelper;
import pers.gwyog.gtneioreplugin.util.OreVeinLayer;

public class PluginGT5VeinStat
extends PluginGT5Base {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (GT5OreLayerHelper.OreLayerWrapper oreVein : this.getAllVeins()) {
                this.addVeinWithLayers(oreVein, 7);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack stack) {
        if (stack.func_77977_a().startsWith("gt.blockores")) {
            this.loadMatchingVeins((short)(stack.func_77960_j() % 1000));
        } else {
            super.loadCraftingRecipes(stack);
        }
    }

    private void loadMatchingVeins(short oreId) {
        for (GT5OreLayerHelper.OreLayerWrapper oreVein : this.getAllVeins()) {
            if (!oreVein.containsOre(oreId)) continue;
            this.addVeinWithLayers(oreVein, this.getMaximumMaterialIndex(oreId, false));
        }
    }

    public void loadUsageRecipes(ItemStack stack) {
        String dimension = ItemDimensionDisplay.getDimension(stack);
        if (dimension == null) {
            return;
        }
        for (GT5OreLayerHelper.OreLayerWrapper oreVein : this.getAllVeins()) {
            if (!Arrays.asList(this.getDimNameArrayFromVeinName(oreVein.veinName)).contains(dimension)) continue;
            this.addVeinWithLayers(oreVein, this.getMaximumMaterialIndex((short)(stack.func_77960_j() % 1000), false));
        }
    }

    private void addVeinWithLayers(GT5OreLayerHelper.OreLayerWrapper oreVein, int maximumMaterialIndex) {
        this.arecipes.add(new CachedVeinStatRecipe(oreVein.veinName, oreVein.getVeinLayerOre(maximumMaterialIndex, 0), oreVein.getVeinLayerOre(maximumMaterialIndex, 1), oreVein.getVeinLayerOre(maximumMaterialIndex, 2), oreVein.getVeinLayerOre(maximumMaterialIndex, 3)));
    }

    private Collection<GT5OreLayerHelper.OreLayerWrapper> getAllVeins() {
        return GT5OreLayerHelper.mapOreLayerWrapper.values();
    }

    public void drawExtras(int recipe) {
        GT5OreLayerHelper.OreLayerWrapper oreLayer = this.getOreLayer(recipe);
        PluginGT5VeinStat.drawVeinName(oreLayer);
        PluginGT5VeinStat.drawVeinLayerNames(oreLayer);
        PluginGT5VeinStat.drawVeinInfo(oreLayer);
        this.drawDimNames();
        this.drawSeeAllRecipesLabel();
    }

    private GT5OreLayerHelper.OreLayerWrapper getOreLayer(int recipe) {
        CachedVeinStatRecipe crecipe = (CachedVeinStatRecipe)((Object)this.arecipes.get(recipe));
        return GT5OreLayerHelper.mapOreLayerWrapper.get(crecipe.veinName);
    }

    private static void drawVeinName(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        if (Loader.isModLoaded((String)"visualprospecting")) {
            PluginGT5VeinStat.drawVeinNameLine(I18n.func_135052_a((String)oreLayer.veinName, (Object[])new Object[0]) + " ");
        } else {
            String veinName = PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]);
            if (veinName.contains("Ore")) {
                PluginGT5VeinStat.drawVeinNameLine(veinName.split("Ore")[0]);
            } else if (veinName.contains("Sand")) {
                PluginGT5VeinStat.drawVeinNameLine(veinName.split("Sand")[0]);
            } else {
                PluginGT5VeinStat.drawVeinNameLine(veinName + " ");
            }
        }
    }

    private static void drawVeinNameLine(String veinName) {
        PluginGT5VeinStat.drawLine("gtnop.gui.nei.veinName", veinName + I18n.func_135052_a((String)"gtnop.gui.nei.vein", (Object[])new Object[0]), 2, 20);
    }

    private static void drawVeinLayerNames(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        PluginGT5VeinStat.drawVeinLayerNameLine(oreLayer, 0, 50);
        PluginGT5VeinStat.drawVeinLayerNameLine(oreLayer, 1, 60);
        PluginGT5VeinStat.drawVeinLayerNameLine(oreLayer, 2, 70);
        PluginGT5VeinStat.drawVeinLayerNameLine(oreLayer, 3, 80);
    }

    private static void drawVeinLayerNameLine(GT5OreLayerHelper.OreLayerWrapper oreLayer, int veinLayer, int height) {
        PluginGT5VeinStat.drawLine(OreVeinLayer.getOreVeinLayerName(veinLayer), PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[veinLayer]), 2, height);
    }

    private static void drawVeinInfo(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        PluginGT5VeinStat.drawLine("gtnop.gui.nei.genHeight", oreLayer.worldGenHeightRange, 2, 90);
        PluginGT5VeinStat.drawLine("gtnop.gui.nei.weightedChance", Integer.toString(oreLayer.randomWeight), 100, 90);
    }

    @Override
    public String getOutputId() {
        return "GTOrePluginVein";
    }

    @Override
    public String getRecipeName() {
        return I18n.func_135052_a((String)"gtnop.gui.veinStat.name", (Object[])new Object[0]);
    }

    private String[] getDimNameArrayFromVeinName(String veinName) {
        GT5OreLayerHelper.OreLayerWrapper oreLayer = GT5OreLayerHelper.mapOreLayerWrapper.get(veinName);
        String[] dims = DimensionHelper.parseDimNames(GT5OreLayerHelper.bufferedDims.get(oreLayer));
        Arrays.sort(dims, Comparator.comparingInt(s -> Arrays.asList(DimensionHelper.DimNameDisplayed).indexOf(s)));
        return dims;
    }

    public class CachedVeinStatRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final String veinName;
        public final PositionedStack positionedStackPrimary;
        public final PositionedStack positionedStackSecondary;
        public final PositionedStack positionedStackBetween;
        public final PositionedStack positionedStackSporadic;
        private final List<PositionedStack> dimensionDisplayItems;

        public CachedVeinStatRecipe(String veinName, List<ItemStack> stackListPrimary, List<ItemStack> stackListSecondary, List<ItemStack> stackListBetween, List<ItemStack> stackListSporadic) {
            super((TemplateRecipeHandler)PluginGT5VeinStat.this);
            this.dimensionDisplayItems = new ArrayList<PositionedStack>();
            this.veinName = veinName;
            this.positionedStackPrimary = new PositionedStack(stackListPrimary, 2, 0);
            this.positionedStackSecondary = new PositionedStack(stackListSecondary, 22, 0);
            this.positionedStackBetween = new PositionedStack(stackListBetween, 42, 0);
            this.positionedStackSporadic = new PositionedStack(stackListSporadic, 62, 0);
            this.setDimensionDisplayItems();
        }

        private void setDimensionDisplayItems() {
            int x = 2;
            int y = 110;
            int count = 0;
            int itemsPerLine = 9;
            int itemSize = 18;
            for (String dim : PluginGT5VeinStat.this.getDimNameArrayFromVeinName(this.veinName)) {
                ItemStack item = ItemDimensionDisplay.getItem(dim);
                if (item == null) continue;
                int xPos = x + itemSize * (count % itemsPerLine);
                int yPos = y + itemSize * (count / itemsPerLine);
                this.dimensionDisplayItems.add(new PositionedStack((Object)item, xPos, yPos, false));
                ++count;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.dimensionDisplayItems;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> outputs = new ArrayList<PositionedStack>();
            this.positionedStackPrimary.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackSecondary.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackBetween.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackSporadic.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            outputs.add(this.positionedStackPrimary);
            outputs.add(this.positionedStackSecondary);
            outputs.add(this.positionedStackBetween);
            outputs.add(this.positionedStackSporadic);
            return outputs;
        }
    }
}

