/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi;

import com.github.bartimaeusnek.bartworks.client.textures.PrefixTextureLinker;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlocks_CasingAdvanced_TE;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.gtnhintergalactic.client.IGTextures;
import com.gtnewhorizons.gtnhintergalactic.client.lore.LoreHolder;
import com.gtnewhorizons.gtnhintergalactic.recipe.GasSiphonRecipes;
import cpw.mods.fml.common.Loader;
import galaxyspace.core.register.GSBlocks;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Casings1;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TileEntityPlanetaryGasSiphon
extends GT_MetaTileEntity_EnhancedMultiBlockBase<TileEntityPlanetaryGasSiphon>
implements IChunkLoader {
    @LoreHolder(value="gt.blockmachines.multimachine.ig.siphon.lore")
    private static String loreTooltip;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final double LOG4;
    private static final IStructureDefinition<TileEntityPlanetaryGasSiphon> STRUCTURE_DEFINITION;
    private int depth;
    private FluidStack fluid = new FluidStack(FluidRegistry.WATER, 0){

        public String getLocalizedName() {
            return "None";
        }
    };
    private boolean mChunkLoadingEnabled = true;
    private ChunkCoordIntPair mCurrentChunk = null;
    private boolean mWorkChunkNeedsReload = true;

    public TileEntityPlanetaryGasSiphon(int id, String name, String regionalName) {
        super(id, name, regionalName);
    }

    public TileEntityPlanetaryGasSiphon(String name) {
        super(name);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 6, 0);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new TileEntityPlanetaryGasSiphon(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.type")).addInfo(loreTooltip != null ? EnumChatFormatting.ITALIC + loreTooltip : "").addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc5")).addSeparator().beginStructureBlock(3, 7, 3, false).addController(GCCoreUtil.translate((String)"ig.siphon.structure.ControllerPos")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.AdvMachineFrame"), GCCoreUtil.translate((String)"ig.siphon.structure.Base")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.ReboltedRhodiumPalladiumCasing"), GCCoreUtil.translate((String)"ig.siphon.structure.PillarMiddle")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.FrameTungstensteel"), GCCoreUtil.translate((String)"ig.siphon.structure.Sides")).addEnergyHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addMaintenanceHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addInputBus(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
        return tt;
    }

    public IStructureDefinition<TileEntityPlanetaryGasSiphon> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.SIPHON_OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.SIPHON_OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.SIPHON_OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.SIPHON_OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX)};
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.mInputBusses.isEmpty() || !((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0)).isValid()) {
            this.resetMachine(true);
            return SimpleCheckRecipeResult.ofFailure((String)"no_mining_pipe");
        }
        WorldProvider worldProvider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        if (!(worldProvider instanceof IOrbitDimension)) {
            this.resetMachine(true);
            return SimpleCheckRecipeResult.ofFailure((String)"no_space_station");
        }
        IOrbitDimension provider = (IOrbitDimension)worldProvider;
        Map<Integer, FluidStack> planetRecipes = GasSiphonRecipes.RECIPES.get(provider.getPlanetToOrbit());
        if (planetRecipes == null) {
            this.resetMachine(true);
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        GT_MetaTileEntity_Hatch_InputBus bus = (GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0);
        int numPipes = 0;
        for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
            ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ItemList.Circuit_Integrated.getItem()) {
                this.depth = stack.func_77960_j();
                continue;
            }
            if (!Objects.equals(stack.func_77973_b(), GT_ModHandler.getIC2Item((String)"miningPipe", (long)0L).func_77973_b())) continue;
            numPipes += stack.field_77994_a;
        }
        if (this.depth == 0 || numPipes < this.depth * 64) {
            this.resetMachine(false);
            return SimpleCheckRecipeResult.ofFailure((String)"no_mining_pipe");
        }
        FluidStack recipeFluid = planetRecipes.get(this.depth);
        if (recipeFluid == null) {
            this.resetMachine(true);
            return SimpleCheckRecipeResult.ofFailure((String)"invalid_depth");
        }
        if (!this.canOutputAll(new FluidStack[]{recipeFluid})) {
            return CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
        }
        int recipeEUt = this.depth * (4 << 2 * provider.getCelestialBody().getTierRequirement() + 2);
        int ocLevel = MathHelper.func_76128_c((double)(Math.log10((double)this.getMaxInputVoltage() / (double)recipeEUt) / LOG4));
        if (ocLevel < 0) {
            this.resetMachine(false);
            return CheckRecipeResultRegistry.insufficientPower((long)recipeEUt);
        }
        this.fluid = recipeFluid.copy();
        if (ocLevel == 0) {
            this.mEUt = -recipeEUt;
        } else {
            this.fluid.amount *= 2 << --ocLevel;
            this.mEUt = -recipeEUt * (4 << 2 * ocLevel);
        }
        this.mOutputFluids = new FluidStack[]{this.fluid};
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return SimpleCheckRecipeResult.ofSuccess((String)"drilling");
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack stack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputHatches.size() == 1 && this.mEnergyHatches.size() == 1 && this.mInputHatches.isEmpty() && this.mOutputBusses.isEmpty();
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer player, float x, float y, float z) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)(this.mChunkLoadingEnabled ? GT_Utility.trans((String)"502", (String)"Mining chunk loading enabled") : GT_Utility.trans((String)"503", (String)"Mining chunk loading disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, player, x, y, z);
    }

    private void resetMachine(boolean resetDepth) {
        if (resetDepth) {
            this.depth = 0;
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
    }

    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public void onPostTick(IGregTechTileEntity baseMetaTileEntity, long tick) {
        super.onPostTick(baseMetaTileEntity, tick);
        if (baseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !baseMetaTileEntity.isAllowedToWork()) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)baseMetaTileEntity));
            this.mWorkChunkNeedsReload = true;
        }
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Depth: " + EnumChatFormatting.YELLOW + this.depth + EnumChatFormatting.RESET, "Fluid: " + EnumChatFormatting.YELLOW + this.fluid.amount + EnumChatFormatting.RESET + "L/s " + EnumChatFormatting.BLUE + this.fluid.getLocalizedName() + EnumChatFormatting.RESET, "EU/t required: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    private static <T> IStructureElement<T> ofReboltedCasing() {
        return new IStructureElement<T>(){
            private final boolean isBartworksLoaded = Loader.isModLoaded((String)"bartworks");
            private final Block fallBackBlock = GT_Block_Casings1.func_149729_e((int)0);
            private final int fallbackBlockMeta = 0;
            private IIcon[] icons;

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.isBartworksLoaded) {
                    if (this.icons == null) {
                        this.icons = new IIcon[6];
                        Arrays.fill(this.icons, ((IIconContainer)((HashMap)PrefixTextureLinker.texMapBlocks.get(OrePrefixes.blockCasingAdvanced)).get(WerkstoffLoader.LuVTierMaterial.getTexSet())).getIcon());
                    }
                    StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.icons, (short[])WerkstoffLoader.LuVTierMaterial.getRGBA());
                } else {
                    StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)this.fallBackBlock, (int)0);
                }
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.isBartworksLoaded) {
                    ItemStack stack = WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.blockCasingAdvanced);
                    Item item = stack.func_77973_b();
                    if (item instanceof ItemBlock) {
                        ItemBlock item2 = (ItemBlock)item;
                        return item2.placeBlockAt(stack, null, world, x, y, z, 6, 0.0f, 0.0f, 0.0f, (int)WerkstoffLoader.LuVTierMaterial.getmID());
                    }
                } else {
                    world.func_147465_d(x, y, z, this.fallBackBlock, 0, 2);
                }
                return false;
            }

            public boolean check(T t, World world, int x, int y, int z) {
                if (this.isBartworksLoaded) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (tile instanceof BW_MetaGeneratedBlocks_CasingAdvanced_TE) {
                        BW_MetaGeneratedBlocks_CasingAdvanced_TE tileCasingAdvanced = (BW_MetaGeneratedBlocks_CasingAdvanced_TE)tile;
                        if (tileCasingAdvanced.func_145837_r()) {
                            return false;
                        }
                        return tileCasingAdvanced.mMetaData == WerkstoffLoader.LuVTierMaterial.getmID();
                    }
                } else {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return worldBlock == this.fallBackBlock;
                }
                return false;
            }
        };
    }

    static {
        LOG4 = Math.log10(4.0);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"   ", " f ", "   "}, {"   ", " f ", "   "}, {"   ", " f ", "   "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {"b~b", "bcb", "bbb"}})).addElement('f', GT_StructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('c', TileEntityPlanetaryGasSiphon.ofReboltedCasing()).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)IGTextures.ADVANCED_MACHINE_FRAME_INDEX, (int)1), StructureUtility.ofBlock((Block)GSBlocks.MachineFrames, (int)0)})).build();
    }
}

