/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.lists;

import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.UnaryOperator;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.objects.utils.ObjectSplititerators;

public interface ObjectList<T>
extends ObjectCollection<T>,
List<T> {
    default public boolean addIfAbsent(T e) {
        if (this.indexOf(e) == -1) {
            return this.add(e);
        }
        return false;
    }

    default public boolean addIfPresent(T e) {
        if (this.indexOf(e) != -1) {
            return this.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(int var1, ObjectCollection<T> var2);

    @Override
    public boolean addAll(ObjectList<T> var1);

    @Override
    public boolean addAll(int var1, ObjectList<T> var2);

    @Override
    default public void replaceAll(UnaryOperator<T> o) {
        Objects.requireNonNull(o);
        ListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(o.apply(iter.next()));
        }
    }

    default public void addElements(T ... a) {
        this.addElements(this.size(), a, 0, a.length);
    }

    default public void addElements(int from, T ... a) {
        this.addElements(from, a, 0, a.length);
    }

    public void addElements(int var1, T[] var2, int var3, int var4);

    default public T[] getElements(int from, T[] a) {
        return this.getElements(from, a, 0, a.length);
    }

    public T[] getElements(int var1, T[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    public T swapRemove(int var1);

    public boolean swapRemove(T var1);

    public <K> K[] extractElements(int var1, int var2, Class<K> var3);

    @Override
    default public void sort(Comparator<? super T> c) {
        Object[] array = this.toArray();
        if (c != null) {
            ObjectArrays.stableSort(array, c);
        } else {
            ObjectArrays.stableSort(array);
        }
        ListIterator iter = this.listIterator();
        int m = this.size();
        for (int i = 0; i < m && iter.hasNext(); ++i) {
            iter.next();
            iter.set(array[i]);
        }
    }

    default public void unstableSort(Comparator<? super T> c) {
        Object[] array = this.toArray();
        if (c != null) {
            ObjectArrays.unstableSort(array, c);
        } else {
            ObjectArrays.unstableSort(array);
        }
        ListIterator iter = this.listIterator();
        int m = this.size();
        for (int i = 0; i < m && iter.hasNext(); ++i) {
            iter.next();
            iter.set(array[i]);
        }
    }

    @Override
    default public void forEachIndexed(IntObjectConsumer<T> action) {
        Objects.requireNonNull(action);
        int i = 0;
        int m = this.size();
        while (i < m) {
            action.accept(i, (T)this.get(i++));
        }
    }

    @Override
    public ObjectListIterator<T> listIterator();

    @Override
    public ObjectListIterator<T> listIterator(int var1);

    @Override
    public ObjectList<T> subList(int var1, int var2);

    public void size(int var1);

    @Override
    public ObjectList<T> copy();

    @Override
    default public ObjectSplititerator<T> spliterator() {
        return ObjectSplititerators.createSplititerator(this, 0);
    }
}

