/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import speiger.src.collections.longs.collections.LongIterable;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.functions.LongComparator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.functions.function.LongFunction;
import speiger.src.collections.longs.utils.LongCollections;
import speiger.src.collections.longs.utils.LongIterators;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.utils.ISizeProvider;

public class LongIterables {
    public static <E> ObjectIterable<E> map(Iterable<? extends Long> iterable, LongFunction<E> mapper) {
        return new MappedIterable<E>(LongIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> map(LongIterable iterable, LongFunction<E> mapper) {
        return new MappedIterable<E>(iterable, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(Iterable<? extends Long> iterable, LongFunction<V> mapper) {
        return new FlatMappedIterable(LongIterables.wrap(iterable), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(LongIterable iterable, LongFunction<V> mapper) {
        return new FlatMappedIterable(iterable, mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(Iterable<? extends Long> iterable, LongFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(LongIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(LongIterable iterable, LongFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(iterable, mapper);
    }

    public static LongIterable filter(Iterable<? extends Long> iterable, LongPredicate filter) {
        return new FilteredIterable(LongIterables.wrap(iterable), filter);
    }

    public static LongIterable filter(LongIterable iterable, LongPredicate filter) {
        return new FilteredIterable(iterable, filter);
    }

    public static LongIterable distinct(LongIterable iterable) {
        return new DistinctIterable(iterable);
    }

    public static LongIterable distinct(Iterable<? extends Long> iterable) {
        return new DistinctIterable(LongIterables.wrap(iterable));
    }

    public static LongIterable repeat(LongIterable iterable, int repeats) {
        return new RepeatingIterable(iterable, repeats);
    }

    public static LongIterable repeat(Iterable<? extends Long> iterable, int repeats) {
        return new RepeatingIterable(LongIterables.wrap(iterable), repeats);
    }

    public static LongIterable limit(LongIterable iterable, long limit) {
        return new LimitedIterable(iterable, limit);
    }

    public static LongIterable limit(Iterable<? extends Long> iterable, long limit) {
        return new LimitedIterable(LongIterables.wrap(iterable), limit);
    }

    public static LongIterable sorted(LongIterable iterable, LongComparator sorter) {
        return new SortedIterable(iterable, sorter);
    }

    public static LongIterable sorted(Iterable<? extends Long> iterable, LongComparator sorter) {
        return new SortedIterable(LongIterables.wrap(iterable), sorter);
    }

    public static LongIterable peek(LongIterable iterable, LongConsumer action) {
        return new PeekIterable(iterable, action);
    }

    public static LongIterable peek(Iterable<? extends Long> iterable, LongConsumer action) {
        return new PeekIterable(LongIterables.wrap(iterable), action);
    }

    public static LongIterable wrap(Iterable<? extends Long> iterable) {
        return new WrappedIterable(iterable);
    }

    private static class PeekIterable
    implements LongIterable,
    ISizeProvider {
        LongIterable iterable;
        LongConsumer action;

        public PeekIterable(LongIterable iterable, LongConsumer action) {
            this.iterable = iterable;
            this.action = action;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.peek(this.iterable.iterator(), this.action);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(this.action.andThen(action));
        }
    }

    private static class DistinctIterable
    implements LongIterable {
        LongIterable iterable;

        public DistinctIterable(LongIterable iterable) {
            this.iterable = iterable;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.distinct(this.iterable.iterator());
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            LongCollections.DistinctCollectionWrapper filtered = LongCollections.distinctWrapper();
            this.iterable.forEach((long T) -> {
                if (filtered.add(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class SortedIterable
    implements LongIterable,
    ISizeProvider {
        LongIterable iterable;
        LongComparator sorter;

        public SortedIterable(LongIterable iterable, LongComparator sorter) {
            this.iterable = iterable;
            this.sorter = sorter;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.sorted(this.iterable.iterator(), this.sorter);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            LongCollections.CollectionWrapper wrapper = LongCollections.wrapper();
            this.iterable.forEach(wrapper::add);
            wrapper.unstableSort(this.sorter);
            wrapper.forEach(action);
        }
    }

    private static class LimitedIterable
    implements LongIterable,
    ISizeProvider {
        LongIterable iterable;
        long limit;

        public LimitedIterable(LongIterable iterable, long limit) {
            this.iterable = iterable;
            this.limit = limit;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.limit(this.iterable.iterator(), this.limit);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : (int)Math.min((long)prov.size(), this.limit);
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            AtomicLong counter = new AtomicLong();
            this.iterable.forEach((long T) -> {
                if (counter.get() >= this.limit) {
                    return;
                }
                counter.incrementAndGet();
                action.accept(T);
            });
        }
    }

    private static class FilteredIterable
    implements LongIterable {
        LongIterable iterable;
        LongPredicate filter;

        public FilteredIterable(LongIterable iterable, LongPredicate filter) {
            this.iterable = iterable;
            this.filter = filter;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.filter(this.iterable.iterator(), this.filter);
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((long T) -> {
                if (!this.filter.test(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class RepeatingIterable
    implements LongIterable,
    ISizeProvider {
        LongIterable iterable;
        int repeats;

        public RepeatingIterable(LongIterable iterable, int repeats) {
            this.iterable = iterable;
            this.repeats = repeats;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.repeat(this.iterable.iterator(), this.repeats);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size() * (this.repeats + 1);
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            LongCollections.CollectionWrapper repeater = LongCollections.wrapper();
            this.iterable.forEach(action.andThen(repeater::add));
            for (int i = 0; i < this.repeats; ++i) {
                repeater.forEach(action);
            }
        }
    }

    private static class FlatMappedArrayIterable<T>
    implements ObjectIterable<T> {
        LongIterable iterable;
        LongFunction<T[]> mapper;

        FlatMappedArrayIterable(LongIterable iterable, LongFunction<T[]> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return LongIterators.arrayFlatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((long E) -> {
                T[] array = this.mapper.apply(E);
                int i = 0;
                int m = array.length;
                while (i < m) {
                    action.accept((T)array[i++]);
                }
            });
        }
    }

    private static class FlatMappedIterable<T, V extends Iterable<T>>
    implements ObjectIterable<T> {
        LongIterable iterable;
        LongFunction<V> mapper;

        FlatMappedIterable(LongIterable iterable, LongFunction<V> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return LongIterators.flatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((long E) -> ((Iterable)this.mapper.apply(E)).forEach(action));
        }
    }

    private static class MappedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        LongIterable iterable;
        LongFunction<T> mapper;

        MappedIterable(LongIterable iterable, LongFunction<T> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return LongIterators.map(this.iterable.iterator(), this.mapper);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((long E) -> action.accept((T)this.mapper.apply(E)));
        }
    }

    private static class WrappedIterable
    implements LongIterable,
    ISizeProvider {
        Iterable<? extends Long> iterable;

        public WrappedIterable(Iterable<? extends Long> iterable) {
            this.iterable = iterable;
        }

        @Override
        public LongIterator iterator() {
            return LongIterators.wrap(this.iterable.iterator());
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(action);
        }
    }
}

