/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.collections;

import java.util.Collection;
import java.util.Objects;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import speiger.src.collections.longs.collections.LongIterable;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.collections.LongSplititerator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.utils.LongCollections;
import speiger.src.collections.longs.utils.LongSplititerators;
import speiger.src.collections.utils.ISizeProvider;
import speiger.src.collections.utils.SanityChecks;

public interface LongCollection
extends Collection<Long>,
LongIterable,
ISizeProvider {
    @Override
    public boolean add(long var1);

    public boolean addAll(LongCollection var1);

    default public boolean addAll(long ... e) {
        return this.addAll(e, 0, e.length);
    }

    default public boolean addAll(long[] e, int length) {
        return this.addAll(e, 0, length);
    }

    default public boolean addAll(long[] e, int offset, int length) {
        if (length <= 0) {
            return false;
        }
        SanityChecks.checkArrayCapacity(e.length, offset, length);
        boolean added = false;
        for (int i = 0; i < length; ++i) {
            if (!this.add(e[offset + i])) continue;
            added = true;
        }
        return added;
    }

    public boolean contains(long var1);

    public boolean containsAll(LongCollection var1);

    public boolean containsAny(LongCollection var1);

    @Deprecated
    public boolean containsAny(Collection<?> var1);

    public boolean remLong(long var1);

    public boolean removeAll(LongCollection var1);

    public boolean removeAll(LongCollection var1, LongConsumer var2);

    public boolean retainAll(LongCollection var1);

    public boolean retainAll(LongCollection var1, LongConsumer var2);

    @Override
    default public <E extends LongCollection> E pour(E collection) {
        collection.addAll(this);
        return collection;
    }

    public LongCollection copy();

    @Override
    public long[] toLongArray();

    public long[] toLongArray(long[] var1);

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Long> filter) {
        Objects.requireNonNull(filter);
        return this.remIf(v -> filter.test(v));
    }

    default public boolean remIf(LongPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        LongIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextLong())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public boolean add(Long o) {
        return this.add((long)o);
    }

    @Override
    @Deprecated
    default public boolean contains(Object o) {
        return o != null && this.contains((Long)o);
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        return o != null && this.remLong((Long)o);
    }

    @Override
    public LongIterator iterator();

    default public LongCollection synchronize() {
        return LongCollections.synchronize(this);
    }

    default public LongCollection synchronize(Object mutex) {
        return LongCollections.synchronize(this, mutex);
    }

    default public LongCollection unmodifiable() {
        return LongCollections.unmodifiable(this);
    }

    default public LongStream primitiveStream() {
        return StreamSupport.longStream(LongSplititerators.createJavaSplititerator(this, 0), false);
    }

    default public LongStream parallelPrimitiveStream() {
        return StreamSupport.longStream(LongSplititerators.createJavaSplititerator(this, 0), true);
    }

    @Override
    default public LongSplititerator spliterator() {
        return LongSplititerators.createSplititerator(this, 0);
    }
}

