/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.collections;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import speiger.src.collections.ints.collections.IntIterable;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.collections.IntSplititerator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.utils.IntCollections;
import speiger.src.collections.ints.utils.IntSplititerators;
import speiger.src.collections.utils.ISizeProvider;
import speiger.src.collections.utils.SanityChecks;

public interface IntCollection
extends Collection<Integer>,
IntIterable,
ISizeProvider {
    @Override
    public boolean add(int var1);

    public boolean addAll(IntCollection var1);

    default public boolean addAll(int ... e) {
        return this.addAll(e, 0, e.length);
    }

    default public boolean addAll(int[] e, int length) {
        return this.addAll(e, 0, length);
    }

    default public boolean addAll(int[] e, int offset, int length) {
        if (length <= 0) {
            return false;
        }
        SanityChecks.checkArrayCapacity(e.length, offset, length);
        boolean added = false;
        for (int i = 0; i < length; ++i) {
            if (!this.add(e[offset + i])) continue;
            added = true;
        }
        return added;
    }

    public boolean contains(int var1);

    public boolean containsAll(IntCollection var1);

    public boolean containsAny(IntCollection var1);

    @Deprecated
    public boolean containsAny(Collection<?> var1);

    public boolean remInt(int var1);

    public boolean removeAll(IntCollection var1);

    public boolean removeAll(IntCollection var1, IntConsumer var2);

    public boolean retainAll(IntCollection var1);

    public boolean retainAll(IntCollection var1, IntConsumer var2);

    @Override
    default public <E extends IntCollection> E pour(E collection) {
        collection.addAll(this);
        return collection;
    }

    public IntCollection copy();

    @Override
    public int[] toIntArray();

    public int[] toIntArray(int[] var1);

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Integer> filter) {
        Objects.requireNonNull(filter);
        return this.remIf(v -> filter.test(v));
    }

    default public boolean remIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        IntIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextInt())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public boolean add(Integer o) {
        return this.add((int)o);
    }

    @Override
    @Deprecated
    default public boolean contains(Object o) {
        return o != null && this.contains((Integer)o);
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        return o != null && this.remInt((Integer)o);
    }

    @Override
    public IntIterator iterator();

    default public IntCollection synchronize() {
        return IntCollections.synchronize(this);
    }

    default public IntCollection synchronize(Object mutex) {
        return IntCollections.synchronize(this, mutex);
    }

    default public IntCollection unmodifiable() {
        return IntCollections.unmodifiable(this);
    }

    default public IntStream primitiveStream() {
        return StreamSupport.intStream(IntSplititerators.createJavaSplititerator(this, 0), false);
    }

    default public IntStream parallelPrimitiveStream() {
        return StreamSupport.intStream(IntSplititerators.createJavaSplititerator(this, 0), true);
    }

    @Override
    default public IntSplititerator spliterator() {
        return IntSplititerators.createSplititerator(this, 0);
    }
}

