/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.witchery;

import alkalus.main.api.RecipeManager;
import alkalus.main.api.plugin.base.BasePluginWitchery;
import com.dreammaster.witchery.WitcheryBrewRegistryAccessor;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.AltarPower;
import com.emoniph.witchery.brewing.BrewItemKey;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.brewing.action.BrewAction;
import com.emoniph.witchery.brewing.action.BrewActionModifier;
import com.emoniph.witchery.brewing.action.BrewActionRitualRecipe;
import com.emoniph.witchery.crafting.KettleRecipes;
import com.emoniph.witchery.crafting.SpinningRecipes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class WitcheryPlugin
extends BasePluginWitchery {
    public WitcheryPlugin() {
        super(EnumSet.of(BasePluginWitchery.LoadPhase.INIT));
    }

    public String getPluginName() {
        return "GTNH Witchery Plugin";
    }

    public boolean preInit() {
        return true;
    }

    private static void ensureItemHaveBrewAction(ItemStack item, int power) {
        if (item != null && WitcheryBrewRegistry.INSTANCE.getActionForItemStack(item) == null) {
            WitcheryBrewRegistryAccessor.registerBrewAction((BrewAction)new EmptyBrewActionModifier(item, power));
        }
    }

    private static void addBrewRecipe(int power, ItemStack result, ItemStack lastItem, ItemStack ... items) {
        if (WitcheryBrewRegistryAccessor.ingredient == null) {
            return;
        }
        BrewItemKey key = BrewItemKey.fromStack((ItemStack)lastItem);
        BrewAction action = WitcheryBrewRegistryAccessor.ingredient.get(key);
        if (action instanceof EmptyBrewActionModifier) {
            action = null;
        }
        for (ItemStack item : items) {
            WitcheryPlugin.ensureItemHaveBrewAction(item, 0);
        }
        if (action == null) {
            WitcheryBrewRegistryAccessor.registerBrewAction((BrewAction)new BrewActionRitualRecipe(key, new AltarPower(power), new BrewActionRitualRecipe.Recipe[]{new BrewActionRitualRecipe.Recipe(result, items)}));
        } else if (action instanceof BrewActionRitualRecipe) {
            BrewActionRitualRecipe ritualRecipe = (BrewActionRitualRecipe)action;
            BrewActionRitualRecipe.Recipe[] old = WitcheryBrewRegistryAccessor.getRecipes(ritualRecipe);
            BrewActionRitualRecipe.Recipe[] recipes = Arrays.copyOf(old, old.length + 1);
            recipes[recipes.length - 1] = new BrewActionRitualRecipe.Recipe(result, items);
            WitcheryBrewRegistryAccessor.modifyBrewRecipe(ritualRecipe, recipes);
        } else {
            WitcheryBrewRegistryAccessor.log.warn("Conflicting brew recipe! key: {}", new Object[]{lastItem});
        }
    }

    private static void removeAllBrewRecipes(ItemStack lastItem) {
        if (WitcheryBrewRegistryAccessor.ingredient == null) {
            return;
        }
        BrewItemKey key = BrewItemKey.fromStack((ItemStack)lastItem);
        BrewAction action = WitcheryBrewRegistryAccessor.ingredient.get(key);
        if (action == null) {
            WitcheryBrewRegistryAccessor.log.warn("There is no brew using {} as last item", new Object[]{lastItem});
            return;
        }
        if (action instanceof BrewActionRitualRecipe) {
            WitcheryBrewRegistryAccessor.removeAction((BrewActionRitualRecipe)action);
        } else {
            WitcheryBrewRegistryAccessor.log.warn("There is no cauldron recipe matching using {} as last item:", new Object[]{lastItem});
        }
    }

    private static void removeBrewRecipe(ItemStack lastItem, ItemStack ... items) {
        if (WitcheryBrewRegistryAccessor.ingredient == null) {
            return;
        }
        BrewItemKey key = BrewItemKey.fromStack((ItemStack)lastItem);
        BrewAction action = WitcheryBrewRegistryAccessor.ingredient.get(key);
        if (action == null) {
            WitcheryBrewRegistryAccessor.log.warn("There is no brew using {} as last item", new Object[]{lastItem});
            return;
        }
        if (action instanceof BrewActionRitualRecipe) {
            BrewActionRitualRecipe ritualRecipe = (BrewActionRitualRecipe)action;
            for (BrewActionRitualRecipe.Recipe recipe : ritualRecipe.getExpandedRecipes()) {
                if (!WitcheryBrewRegistryAccessor.isCauldronRecipeMatch(recipe, lastItem, items)) continue;
                if (ritualRecipe.getExpandedRecipes().size() > 1) {
                    WitcheryBrewRegistryAccessor.modifyBrewRecipe(ritualRecipe, (BrewActionRitualRecipe.Recipe[])ritualRecipe.getExpandedRecipes().stream().filter(r -> r != recipe).map(r -> new BrewActionRitualRecipe.Recipe(r.result, Arrays.copyOf(r.ingredients, r.ingredients.length - 1))).toArray(BrewActionRitualRecipe.Recipe[]::new));
                } else {
                    WitcheryBrewRegistryAccessor.removeAction(ritualRecipe);
                }
                return;
            }
        }
        WitcheryBrewRegistryAccessor.log.warn("There is no cauldron recipe matching these items: last: {}, rest: " + Arrays.toString(items), new Object[]{lastItem});
    }

    private static void removeAllKettleRecipe(ItemStack output) {
        KettleRecipes.instance().recipes.removeIf(recipe -> recipe.output.func_77969_a(output));
    }

    private static void removeRecipe(KettleRecipes.KettleRecipe recipe) {
        if (!KettleRecipes.instance().recipes.remove(recipe)) {
            WitcheryBrewRegistryAccessor.log.warn("Recipe already removed: {}", new Object[]{recipe});
        }
    }

    public boolean init() {
        RecipeManager.SpinningWheel.removeRecipe((ItemStack)Witchery.Items.GENERIC.itemGoldenThread.createStack(3), (ItemStack)new ItemStack(Blocks.field_150407_cf), (ItemStack[])new ItemStack[]{Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1)});
        SpinningRecipes.instance().recipes.remove(RecipeManager.SpinningWheel.getRecipe((ItemStack)new ItemStack(Items.field_151007_F, 8, 0), (ItemStack[])new ItemStack[0]));
        RecipeManager.SpinningWheel.removeRecipe((ItemStack)Witchery.Items.GENERIC.itemTormentedTwine.createStack(1), (ItemStack)Witchery.Items.GENERIC.itemDisturbedCotton.createStack(4), (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151007_F), Witchery.Items.GENERIC.itemReekOfMisfortune.createStack(1)});
        RecipeManager.SpinningWheel.removeRecipe((ItemStack)Witchery.Items.GENERIC.itemFancifulThread.createStack(1), (ItemStack)new ItemStack(Witchery.Blocks.WISPY_COTTON, 4), (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151007_F), Witchery.Items.GENERIC.itemOdourOfPurity.createStack(1)});
        RecipeManager.SpinningWheel.addRecipe((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)8L), (ItemStack)Witchery.Items.GENERIC.itemGoldenThread.createStack(1), (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151007_F, 8, 0), Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1)});
        RecipeManager.SpinningWheel.addRecipe((ItemStack)Witchery.Items.GENERIC.itemGoldenThread.createStack(1), (ItemStack)Witchery.Items.GENERIC.itemFancifulThread.createStack(1), (ItemStack[])new ItemStack[]{new ItemStack(Witchery.Blocks.WISPY_COTTON, 4), Witchery.Items.GENERIC.itemOdourOfPurity.createStack(1)});
        RecipeManager.SpinningWheel.addRecipe((ItemStack)GT_ModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_burned_string", (long)1L), (ItemStack)Witchery.Items.GENERIC.itemTormentedTwine.createStack(1), (ItemStack[])new ItemStack[]{Witchery.Items.GENERIC.itemDisturbedCotton.createStack(4), Witchery.Items.GENERIC.itemReekOfMisfortune.createStack(1)});
        RecipeManager.SpinningWheel.addRecipe((ItemStack)new ItemStack(Items.field_151007_F, 8, 0), (ItemStack)new ItemStack(Blocks.field_150321_G, 1, 0), (ItemStack[])new ItemStack[]{Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1)});
        WitcheryPlugin.removeAllKettleRecipe(Witchery.Items.GENERIC.itemSpiritOfOtherwhere.createStack());
        RecipeManager.Kettle.addRecipe((ItemStack)Witchery.Items.GENERIC.itemSpiritOfOtherwhere.createStack(2), (int)0, (int)0, (float)6000.0f, (int)-7128833, (int)0, (boolean)true, (ItemStack[])new ItemStack[]{Witchery.Items.GENERIC.itemRedstoneSoup.createStack(), Witchery.Items.GENERIC.itemBrewOfFlowingSpirit.createStack(), GT_ModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)45), GT_ModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"end_powder", (long)1L), Witchery.Items.GENERIC.itemDropOfLuck.createStack(), Witchery.Items.GENERIC.itemBatWool.createStack()});
        WitcheryPlugin.removeAllBrewRecipes(new ItemStack(Witchery.Items.CHALK_RITUAL));
        WitcheryPlugin.addBrewRecipe(1000, new ItemStack(Witchery.Items.CHALK_GOLDEN), new ItemStack(Witchery.Items.CHALK_RITUAL), Witchery.Items.GENERIC.itemMandrakeRoot.createStack(), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Gold, (long)1L), Witchery.Items.GENERIC.itemDiamondVapour.createStack());
        WitcheryPlugin.addBrewRecipe(2000, new ItemStack(Witchery.Items.CHALK_INFERNAL), new ItemStack(Witchery.Items.CHALK_RITUAL), new ItemStack(Items.field_151075_bm), new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151156_bN));
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            WitcheryPlugin.addBrewRecipe(4000, new ItemStack(Witchery.Items.CHALK_OTHERWHERE), new ItemStack(Witchery.Items.CHALK_RITUAL), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.EnderEye, (long)1L), GT_ModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"end_powder", (long)1L), Witchery.Items.GENERIC.itemTearOfTheGoddess.createStack(), GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.ManyullynCrystal", (long)1L, (int)0));
        }
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private static class EmptyBrewActionModifier
    extends BrewActionModifier {
        public EmptyBrewActionModifier(ItemStack item, int power) {
            super(BrewItemKey.fromStack((ItemStack)item), null, new AltarPower(power));
        }
    }
}

