/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2")
public class TileEntityFLElectric
extends TileEntityMetaFloodlight
implements IEnergyHandler,
IEnergySink {
    protected boolean wasAddedToEnergyNet = false;
    protected double storageEU;
    protected EnergyStorage storage = new EnergyStorage(50000);

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("storageEU")) {
            this.storageEU = nbtTagCompound.func_74769_h("storageEU");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.storage.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74780_a("storageEU", this.storageEU);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public void setEnergyStored(int energyStored) {
        this.storage.setEnergyStored(energyStored);
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection forgeDirection, double v, double v1) {
        if ((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) >= v * 8.0) {
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 8.0));
        } else {
            this.storageEU += v - (double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) / 8.0;
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 8.0));
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return Math.max(4000.0 - this.storageEU, 0.0);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    @Optional.Method(modid="IC2")
    protected void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="IC2")
    protected void removeFromIc2EnergyNetwork() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.wasAddedToEnergyNet && ModCompatibility.IC2Loaded) {
            this.removeFromIc2EnergyNetwork();
            this.wasAddedToEnergyNet = false;
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtil.isItemStackValidElectrical(itemstack);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return GeneralUtil.isItemStackValidElectrical(itemstack);
    }
}

